/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.filter;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.filter.Filter;
import org.ut.biolab.medsavant.client.filter.FilterEvent;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.project.ProjectEvent;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.reference.ReferenceEvent;
import org.ut.biolab.medsavant.client.util.Controller;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.login.LoginEvent;

public class FilterController
extends Controller<FilterEvent> {
    private static final Log LOG = LogFactory.getLog(FilterController.class);
    private static FilterController instance;
    private int filterSetID = 0;
    private Map<Integer, Map<String, Filter>> filterMap = new TreeMap<Integer, Map<String, Filter>>();
    private Condition newConditions = BinaryCondition.equalTo(1, 1);

    private FilterController() {
        ProjectController.getInstance().addListener(new Listener<ProjectEvent>(){

            @Override
            public void handleEvent(ProjectEvent evt) {
                if (evt.getType() == ProjectEvent.Type.CHANGED) {
                    FilterController.this.removeAllFilters();
                }
            }
        });
        ReferenceController.getInstance().addListener(new Listener<ReferenceEvent>(){

            @Override
            public void handleEvent(ReferenceEvent event) {
                if (event.getType() == ReferenceEvent.Type.CHANGED) {
                    FilterController.this.removeAllFilters();
                }
            }
        });
        LoginController.getInstance().addListener(new Listener<LoginEvent>(){

            @Override
            public void handleEvent(LoginEvent evt) {
                if (evt.getType() == LoginEvent.Type.LOGGED_OUT) {
                    FilterController.this.removeAllFilters();
                }
            }
        });
    }

    public static FilterController getInstance() {
        if (instance == null) {
            instance = new FilterController();
        }
        return instance;
    }

    @Override
    public void fireEvent(FilterEvent evt) {
        ++this.filterSetID;
        super.fireEvent(evt);
    }

    public void addFilter(Filter filter, int queryID) {
        Filter prev;
        if (this.filterMap.get(queryID) == null) {
            this.filterMap.put(queryID, new TreeMap());
        }
        this.fireEvent(new FilterEvent((prev = this.filterMap.get(queryID).put(filter.getID(), filter)) == null ? FilterEvent.Type.ADDED : FilterEvent.Type.MODIFIED, filter));
    }

    public void removeFilter(String filtID, int queryID) {
        if (this.filterMap.get(queryID) != null) {
            Filter removed = this.filterMap.get(queryID).remove(filtID);
            if (this.filterMap.get(queryID).isEmpty()) {
                this.filterMap.remove(queryID);
            }
            if (removed != null) {
                this.fireEvent(new FilterEvent(FilterEvent.Type.REMOVED, removed));
            }
        }
    }

    public void removeQuery(int queryID) {
        Map<String, Filter> map = this.filterMap.remove(queryID);
        if (map == null || map.isEmpty()) {
            return;
        }
        Filter f = new Filter(){

            @Override
            public String getName() {
                return "Filter Set";
            }

            @Override
            public String getID() {
                return null;
            }

            @Override
            public Condition[] getConditions() {
                return null;
            }
        };
        this.fireEvent(new FilterEvent(FilterEvent.Type.REMOVED, f));
    }

    public void removeAllFilters() {
        this.filterMap.clear();
    }

    public int getCurrentFilterSetID() {
        return this.filterSetID;
    }

    public Filter getFilter(String title, int queryID) {
        return this.filterMap.get(queryID).get(title);
    }

    public Condition[] getFilterConditions(int queryID) throws InterruptedException, SQLException, RemoteException {
        return new Condition[]{this.newConditions};
    }

    public Condition[][] getAllFilterConditions() throws InterruptedException, SQLException, RemoteException {
        return new Condition[][]{{this.newConditions}};
    }

    public boolean hasFiltersApplied() {
        for (Integer key : this.filterMap.keySet()) {
            Map<String, Filter> current = this.filterMap.get(key);
            if (current == null || current.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void setConditions(Condition conds) {
        this.newConditions = conds;
        this.fireEvent(new FilterEvent(FilterEvent.Type.MODIFIED, new Filter(){

            @Override
            public String getName() {
                return "";
            }

            @Override
            public String getID() {
                return "";
            }

            @Override
            public Condition[] getConditions() throws InterruptedException, SQLException, RemoteException {
                return new Condition[0];
            }
        }));
    }
}

