/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.filter;

import org.ut.biolab.medsavant.client.filter.BooleanFilterView;
import org.ut.biolab.medsavant.client.filter.FilterHolder;
import org.ut.biolab.medsavant.client.filter.FilterState;
import org.ut.biolab.medsavant.client.filter.FilterView;
import org.ut.biolab.medsavant.client.filter.NumericFilterView;
import org.ut.biolab.medsavant.client.filter.StringListFilterView;
import org.ut.biolab.medsavant.client.filter.WhichTable;
import org.ut.biolab.medsavant.shared.format.BasicPatientColumns;
import org.ut.biolab.medsavant.shared.format.CustomField;

class FieldFilterHolder
extends FilterHolder {
    private final CustomField field;
    private final WhichTable whichTable;

    FieldFilterHolder(CustomField field, WhichTable table, int queryID) {
        super(field.getAlias(), field.getColumnName(), queryID);
        this.field = field;
        this.whichTable = table;
    }

    @Override
    public FilterView createFilterView() throws Exception {
        String colName = this.field.getColumnName();
        String alias = this.field.getAlias();
        switch (this.field.getColumnType()) {
            case INTEGER: {
                if (colName.equals(BasicPatientColumns.PATIENT_ID.getColumnName()) || colName.equals(BasicPatientColumns.GENDER.getColumnName())) break;
                return new NumericFilterView(this.whichTable, colName, this.queryID, alias, false);
            }
            case FLOAT: 
            case DECIMAL: {
                return new NumericFilterView(this.whichTable, colName, this.queryID, alias, true);
            }
        }
        return new StringListFilterView(this.whichTable, colName, this.queryID, alias);
    }

    @Override
    public void loadFilterView(FilterState state) throws Exception {
        switch (state.getType()) {
            case NUMERIC: {
                this.filterView = new NumericFilterView(state, this.queryID);
                break;
            }
            case STRING: {
                this.filterView = new StringListFilterView(state, this.queryID);
                break;
            }
            case BOOLEAN: {
                this.filterView = new BooleanFilterView(state, this.queryID);
                break;
            }
            default: {
                throw new Exception("Unknown filter type " + (Object)((Object)state.getType()));
            }
        }
    }
}

