/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.controller.SettingsController;
import org.ut.biolab.medsavant.client.settings.DirectorySettings;
import org.ut.biolab.medsavant.client.view.login.MedSavantServerInfo;

public class ServerController {
    private final ArrayList<Listener<ServerController>> listeners;
    Log LOG = LogFactory.getLog(ServerController.class);
    List<MedSavantServerInfo> servers;
    MedSavantServerInfo tmpServer;
    private final String SERVER_FILE_NAME = ".servers";
    private static final String KEY_SETTING_LASTSERVER_NICKNAME = "server-nickname";
    private static ServerController instance;
    private MedSavantServerInfo currentServer;

    public static synchronized ServerController getInstance() {
        if (instance == null) {
            instance = new ServerController();
        }
        return instance;
    }

    private ServerController() {
        this.listeners = new ArrayList();
        this.loadServers();
        String serverNickName = SettingsController.getInstance().getValue(KEY_SETTING_LASTSERVER_NICKNAME);
        if (serverNickName != null) {
            MedSavantServerInfo server = this.getServerWithName(serverNickName);
            if (server != null) {
                this.setCurrentServer(server);
            }
        } else if (this.servers.size() > 0) {
            this.setCurrentServer(this.servers.get(0));
        }
    }

    public void setCurrentServer(MedSavantServerInfo server) {
        this.currentServer = server;
        if (server == null) {
            SettingsController.getInstance().setValue(KEY_SETTING_LASTSERVER_NICKNAME, null);
        } else {
            SettingsController.getInstance().setValue(KEY_SETTING_LASTSERVER_NICKNAME, server.getNickname());
            this.LOG.info((Object)("Setting server to " + server.getNickname()));
        }
        this.notifyListeners();
    }

    private void notifyListeners() {
        for (Listener<ServerController> l : this.listeners) {
            l.handleEvent(null);
        }
    }

    private MedSavantServerInfo getServerWithName(String serverNickName) {
        for (MedSavantServerInfo s : this.servers) {
            if (!s.getNickname().equals(serverNickName)) continue;
            return s;
        }
        return null;
    }

    private File getServerFile() {
        return new File(DirectorySettings.getMedSavantDirectory(), ".servers");
    }

    public void addServer(MedSavantServerInfo server) {
        this.LOG.info((Object)("Adding server " + server.getNickname() + " count is " + this.servers.size()));
        this.servers.add(server);
        this.saveServers();
    }

    public void addTemporaryServer(MedSavantServerInfo server) {
        this.tmpServer = server;
        this.saveServers();
    }

    public synchronized void saveServers() {
        this.saveServers(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveServers(boolean notifyListeners) {
        FileOutputStream fileout = null;
        Writer out = null;
        ArrayList<MedSavantServerInfo> serversWithPasswordsRemoved = new ArrayList<MedSavantServerInfo>();
        for (MedSavantServerInfo s : this.servers) {
            MedSavantServerInfo clone = new MedSavantServerInfo(s);
            if (!clone.isRememberPassword()) {
                clone.setPassword("");
            }
            serversWithPasswordsRemoved.add(clone);
        }
        try {
            fileout = new FileOutputStream(this.getServerFile());
            out = new OutputStreamWriter((OutputStream)fileout, "UTF-8");
            Gson gson = new GsonBuilder().create();
            gson.toJson(serversWithPasswordsRemoved, (Appendable)out);
            out.close();
            fileout.close();
            this.LOG.info((Object)("Saved " + serversWithPasswordsRemoved.size() + " servers"));
        }
        catch (Exception ex) {
            this.LOG.error((Object)"Problem saving servers", (Throwable)ex);
            ex.printStackTrace();
        }
        finally {
            try {
                out.close();
            }
            catch (Exception ex) {}
            try {
                fileout.close();
            }
            catch (Exception ex) {}
        }
        if (notifyListeners) {
            this.notifyListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadServers() {
        FileInputStream filein = null;
        Reader in = null;
        try {
            if (!this.getServerFile().exists()) {
                this.servers = new ArrayList<MedSavantServerInfo>();
                this.saveServers();
            } else {
                filein = new FileInputStream(this.getServerFile());
                in = new InputStreamReader(filein);
                this.LOG.info((Object)"Deserializing servers");
                try {
                    Gson gson = new GsonBuilder().create();
                    Type type = new TypeToken<List<MedSavantServerInfo>>(){}.getType();
                    this.servers = (List)gson.fromJson(in, type);
                }
                catch (Exception e) {
                    this.LOG.info((Object)("Corrupted server file, recreating " + e));
                    this.getServerFile().delete();
                    this.servers = new ArrayList<MedSavantServerInfo>();
                    this.saveServers();
                }
                in.close();
                filein.close();
            }
            this.LOG.info((Object)("Loaded " + this.servers.size() + " servers"));
        }
        catch (Exception ex) {
            this.LOG.error((Object)"Problem loading servers", (Throwable)ex);
            this.servers = new ArrayList<MedSavantServerInfo>();
        }
        finally {
            try {
                in.close();
            }
            catch (Exception ex) {}
            try {
                filein.close();
            }
            catch (Exception exception) {}
        }
    }

    public void removeServer(MedSavantServerInfo server) {
        this.LOG.info((Object)("Removing server " + server.getNickname() + " count is " + this.servers.size()));
        this.servers.remove(server);
        if (this.currentServer == server) {
            this.setCurrentServer(null);
        }
        this.saveServers();
    }

    public MedSavantServerInfo getServerNamed(String name) {
        for (MedSavantServerInfo s : this.servers) {
            if (!s.getNickname().equals(name)) continue;
            return s;
        }
        return null;
    }

    public MedSavantServerInfo getCurrentServer() {
        return this.currentServer;
    }

    public void addListener(Listener<ServerController> serverListener) {
        this.listeners.add(serverListener);
    }

    public List<MedSavantServerInfo> getServers() {
        return this.servers;
    }

    public boolean isServerNamed(String name) {
        return this.getServerNamed(name) != null;
    }
}

