/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.cohort;

import com.healthmarketscience.sqlbuilder.Condition;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.api.FilterStateAdapter;
import org.ut.biolab.medsavant.client.filter.Filter;
import org.ut.biolab.medsavant.client.filter.FilterController;
import org.ut.biolab.medsavant.client.filter.FilterState;
import org.ut.biolab.medsavant.client.filter.TabularFilterView;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.shared.model.Cohort;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;

public class CohortFilterView
extends TabularFilterView<Cohort> {
    public static final String FILTER_NAME = "Cohort";
    public static final String FILTER_ID = "cohort";

    public CohortFilterView(FilterState state, int queryID) throws SQLException, RemoteException {
        this(queryID);
        List<String> values = state.getValues("value");
        if (values != null) {
            this.setFilterValues(values);
        }
    }

    public CohortFilterView(int queryID) throws SQLException, RemoteException {
        super(FILTER_NAME, queryID);
        ArrayList<Cohort> vals = new ArrayList<Cohort>();
        try {
            vals.addAll(Arrays.asList(MedSavantClient.CohortManager.getCohorts(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID())));
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
        }
        this.setAvailableValues(vals);
        this.initContentPanel();
    }

    public static FilterState wrapState(Collection<Cohort> applied) {
        FilterState state = new FilterState(Filter.Type.COHORT, FILTER_NAME, FILTER_ID);
        state.putValues("value", CohortFilterView.wrapValues(applied));
        return state;
    }

    @Override
    public FilterStateAdapter saveState() {
        return CohortFilterView.wrapState(this.appliedValues);
    }

    @Override
    protected void applyFilter() {
        this.preapplyFilter();
        FilterController.getInstance().addFilter(new CohortFilter(), this.queryID);
    }

    private class CohortFilter
    extends Filter {
        private CohortFilter() {
        }

        @Override
        public String getName() {
            return CohortFilterView.FILTER_NAME;
        }

        @Override
        public String getID() {
            return CohortFilterView.FILTER_ID;
        }

        @Override
        public Condition[] getConditions() throws SQLException, RemoteException {
            if (CohortFilterView.this.appliedValues.size() > 0) {
                ArrayList<String> cohNames = new ArrayList<String>();
                for (Cohort coh : CohortFilterView.this.appliedValues) {
                    cohNames.add(coh.getName());
                }
                try {
                    return this.getDNAIDCondition(MedSavantClient.CohortManager.getDNAIDsForCohorts(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), cohNames));
                }
                catch (SessionExpiredException ex) {
                    MedSavantExceptionHandler.handleSessionExpiredException(ex);
                }
            }
            return FALSE_CONDITION;
        }
    }
}

