/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.cohort;

import java.util.List;
import javax.swing.SwingUtilities;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.cohort.CohortWizard;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.view.dialog.ProgressDialog;
import org.ut.biolab.medsavant.client.view.list.DetailedListEditor;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.shared.model.Cohort;

public class CohortDetailedListEditor
extends DetailedListEditor {
    @Override
    public boolean doesImplementAdding() {
        return true;
    }

    @Override
    public boolean doesImplementDeleting() {
        return true;
    }

    @Override
    public void addItems() {
        new CohortWizard().setVisible(true);
    }

    @Override
    public void deleteItems(final List<Object[]> items) {
        int result;
        if (items.size() == 1) {
            String name = ((Cohort)items.get(0)[0]).getName();
            result = DialogUtils.askYesNo("Confirm", "<html>Are you sure you want to remove <i>%s</i>?<br>This cannot be undone.</html>", name);
        } else {
            result = DialogUtils.askYesNo("Confirm", "Are you sure you want to remove these %d cohorts?\nThis cannot be undone.", items.size());
        }
        if (result == 0) {
            new ProgressDialog("Removing Cohort(s)", items.size() + " cohort(s) being removed.  Please wait."){

                @Override
                public void run() {
                    int numCouldntRemove = 0;
                    for (Object[] v : items) {
                        int id = ((Cohort)v[0]).getId();
                        try {
                            MedSavantClient.CohortManager.removeCohort(LoginController.getSessionID(), id);
                        }
                        catch (Exception ex) {
                            ++numCouldntRemove;
                            ClientMiscUtils.reportError("Error removing " + ((Cohort)v[0]).getName() + ": %s", ex);
                        }
                    }
                    this.setVisible(false);
                    final int cohortsRemoved = items.size() - numCouldntRemove;
                    if (numCouldntRemove != items.size()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DialogUtils.displayMessage("Successfully removed " + cohortsRemoved + " cohort(s).");
                            }
                        });
                    }
                    this.dispose();
                }
            }.setVisible(true);
        }
    }
}

