/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.app.page;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import org.ut.biolab.medsavant.client.app.AppInfo;
import org.ut.biolab.medsavant.client.app.page.AppInfoFlowView;
import org.ut.biolab.medsavant.client.app.page.AppStoreInstalledPage;
import org.ut.biolab.medsavant.client.app.page.InstallActionListener;

public class AppInfoModal
extends JDialog {
    private final AppStoreInstalledPage installedPage;
    private final JTabbedPane parent;
    private final JButton downloadButton;
    private final InstallActionListener ail;

    public AppInfoModal(AppInfo i, AppStoreInstalledPage installedPage, JTabbedPane avm) {
        super((Frame)null, i.getName(), true);
        this.setModal(true);
        this.setResizable(false);
        this.setBackground(Color.white);
        this.installedPage = installedPage;
        this.parent = avm;
        Dimension d = new Dimension(400, 400);
        this.setPreferredSize(d);
        this.setMinimumSize(d);
        this.setLocationRelativeTo(null);
        JPanel mig = new JPanel();
        mig.setBackground(Color.white);
        mig.setLayout((LayoutManager)new MigLayout("wrap 1"));
        JLabel nameLabel = new JLabel("<html><b>" + i.getName() + "</b> " + i.getVersion() + "</html>");
        Font font = nameLabel.getFont();
        Font boldFont = new Font(font.getFontName(), 1, font.getSize());
        Font smallFont = new Font(font.getFontName(), 0, font.getSize() - 3);
        Font mediumFont = new Font(font.getFontName(), 0, font.getSize() - 2);
        JLabel categoryLabel = new JLabel(i.getCategory());
        categoryLabel.setForeground(Color.darkGray);
        categoryLabel.setFont(smallFont);
        JLabel authorLabel = new JLabel("Developed by " + i.getAuthor());
        authorLabel.setFont(mediumFont);
        authorLabel.setForeground(Color.darkGray);
        JTextArea description = new JTextArea();
        description.setEditable(false);
        description.setFocusable(false);
        description.setOpaque(false);
        description.setLineWrap(true);
        description.setText(i.getDescription());
        this.downloadButton = AppInfoFlowView.getSoftButton("Install App");
        JButton moreInfo = AppInfoFlowView.getSoftButton("More Info");
        AppInfoModal thisInstance = this;
        this.ail = new InstallActionListener(installedPage, i, avm);
        this.downloadButton.addActionListener(this.ail);
        JPanel actionBar = new JPanel();
        actionBar.setOpaque(false);
        actionBar.setLayout(new BoxLayout(actionBar, 0));
        actionBar.add(this.downloadButton);
        mig.add(nameLabel);
        mig.add(categoryLabel);
        mig.add(Box.createVerticalStrut(3));
        mig.add(authorLabel);
        mig.add(Box.createVerticalStrut(3));
        mig.add((Component)description, "width 100%");
        mig.add(actionBar);
        this.add(mig);
    }

    final void setInstalled(boolean installedAlready) {
        if (installedAlready) {
            this.downloadButton.setEnabled(false);
            this.downloadButton.setText("Installed");
            this.downloadButton.updateUI();
            this.downloadButton.invalidate();
        }
    }

    void setUpdateAllowed(boolean canUpdate) {
        if (canUpdate) {
            this.downloadButton.setText("Update");
            this.ail.setModeToUpdate(true);
        }
    }
}

