/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.app.page;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;
import org.ut.biolab.medsavant.client.app.AppInfo;
import org.ut.biolab.medsavant.client.app.page.AppInfoModal;
import org.ut.biolab.medsavant.client.app.page.AppStoreInstalledPage;
import org.ut.biolab.medsavant.client.app.page.InstallActionListener;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

class AppInfoFlowView
extends JPanel {
    private final AppStoreInstalledPage installedPage;
    private final JTabbedPane parent;
    private final JButton downloadButton;
    private final AppInfoModal aim;
    private final InstallActionListener ial;

    public AppInfoFlowView(AppInfo i, JTabbedPane parent, AppStoreInstalledPage installedPage, boolean installedAlready, boolean canUpdate) {
        this.parent = parent;
        this.installedPage = installedPage;
        this.setLayout((LayoutManager)new MigLayout("fillx"));
        this.setBackground(Color.white);
        String shortName = i.getName();
        JLabel nameLabel = new JLabel("<html><b>" + shortName + "</b> " + i.getVersion() + "</html>");
        if (!shortName.equals(i.getName())) {
            nameLabel.setToolTipText(i.getName());
        }
        Font font = nameLabel.getFont();
        Font boldFont = new Font(font.getFontName(), 1, font.getSize());
        Font smallFont = new Font(font.getFontName(), 0, font.getSize() - 3);
        Font mediumFont = new Font(font.getFontName(), 0, font.getSize() - 2);
        JLabel categoryLabel = new JLabel(i.getCategory());
        categoryLabel.setForeground(Color.darkGray);
        categoryLabel.setFont(smallFont);
        JLabel authorLabel = new JLabel(i.getAuthor());
        authorLabel.setFont(mediumFont);
        authorLabel.setForeground(Color.darkGray);
        this.downloadButton = AppInfoFlowView.getSoftButton("Install App");
        JButton infoButton = ViewUtil.getHelpButton("", "");
        this.ial = new InstallActionListener(installedPage, i, parent);
        this.downloadButton.addActionListener(this.ial);
        this.aim = new AppInfoModal(i, installedPage, parent);
        if (installedAlready) {
            if (canUpdate) {
                this.setUpdateAllowed(true);
            } else {
                this.setInstalled(true);
            }
        }
        JPanel actionBar = new JPanel();
        actionBar.setOpaque(false);
        actionBar.setLayout(new BoxLayout(actionBar, 0));
        actionBar.add(Box.createHorizontalGlue());
        actionBar.add(this.downloadButton);
        this.add((Component)nameLabel, "wrap");
        this.add((Component)categoryLabel, "wrap");
        this.add(authorLabel);
        this.add((Component)actionBar, "right, wrap");
        int border = 20;
        this.setBorder(BorderFactory.createCompoundBorder(ViewUtil.getTinyLineBorder(), BorderFactory.createEmptyBorder(border, border, border, border)));
        this.updateUI();
    }

    public static JButton getSoftButton(String string) {
        JButton b = new JButton(string);
        b.setFocusable(false);
        b.putClientProperty("JComponent.sizeVariant", "small");
        return b;
    }

    public static JPanel getLeftAlignedComponent(Component c) {
        JPanel p = new JPanel();
        p.setOpaque(false);
        p.setLayout(new BoxLayout(p, 0));
        p.add(c);
        p.add(Box.createHorizontalGlue());
        return p;
    }

    final void setInstalled(boolean installedAlready) {
        if (installedAlready) {
            this.downloadButton.setEnabled(false);
            this.downloadButton.setText("Installed");
            this.downloadButton.updateUI();
            this.downloadButton.invalidate();
        }
        this.aim.setInstalled(installedAlready);
    }

    private void setUpdateAllowed(boolean canUpdate) {
        if (canUpdate) {
            this.downloadButton.setText("Update");
            this.ial.setModeToUpdate(true);
        }
        this.aim.setUpdateAllowed(canUpdate);
    }
}

