/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.app;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.app.AppInfo;
import org.ut.biolab.medsavant.client.app.api.AppInfoFetcher;
import org.ut.biolab.medsavant.client.plugin.AppDescriptor;
import org.ut.biolab.medsavant.shared.util.VersionSettings;
import org.ut.biolab.medsavant.shared.util.WebResources;

public class MedSavantAppFetcher
implements AppInfoFetcher {
    private static Log LOG = LogFactory.getLog(MedSavantAppFetcher.class);
    private static final String[] REQUIRED_PAIRS = new String[]{"url", "name", "version", "sdk-version", "category", "author", "description"};
    private List<AppInfo> appInfo;

    private static XMLElement readElement(XMLStreamReader reader) {
        try {
            String elemName = reader.getLocalName().toUpperCase();
            return Enum.valueOf(XMLElement.class, elemName);
        }
        catch (IllegalArgumentException ignored) {
            return XMLElement.ERROR;
        }
    }

    private AppInfo getAppInfo(Map<String, String> pluginMap, String repositoryURL) throws MalformedURLException, IOException {
        for (String key : REQUIRED_PAIRS) {
            if (pluginMap.get(key) != null) continue;
            String n = pluginMap.get("name");
            if (n == null) {
                n = "<Unknown Plugin>";
            }
            throw new IOException("Invalid plugin repository xml at " + repositoryURL + ", plugin " + n + " is missing value for '" + key + "'");
        }
        String name = pluginMap.get("name");
        String version = pluginMap.get("version");
        String compatibleWith = pluginMap.get("sdk-version");
        String category = pluginMap.get("category");
        if (category != null) {
            category = Enum.valueOf(AppDescriptor.Category.class, category.toUpperCase()).toString();
        }
        String description = pluginMap.get("description");
        String shortdesc = pluginMap.get("shortdescription");
        String newinversion = pluginMap.get("newinversion");
        String author = pluginMap.get("author");
        String web = pluginMap.get("webpage");
        URL downloadURL = new URL(pluginMap.get("url"));
        LOG.info((Object)("Located plugin " + name + " in App repository"));
        return new AppInfo(name, version, category, compatibleWith, shortdesc, newinversion, description, author, web, downloadURL);
    }

    private void refreshAppInfo(String[] pluginRepositoryUrls) throws Exception {
        this.appInfo = new LinkedList<AppInfo>();
        for (String repositoryURL : pluginRepositoryUrls) {
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new URL(repositoryURL).openConnection().getInputStream());
            HashMap<String, String> pluginMap = new HashMap<String, String>();
            XMLElement currentElement = null;
            String currentText = "";
            block11: do {
                block0 : switch (reader.next()) {
                    case 1: {
                        currentElement = MedSavantAppFetcher.readElement(reader);
                        currentText = "";
                        switch (currentElement) {
                            case PLUGINS: 
                            case PLUGIN: {
                                pluginMap.clear();
                                for (XMLPluginAttribute a : XMLPluginAttribute.values()) {
                                    String attrName = a.toString().toLowerCase();
                                    String attrVal = reader.getAttributeValue(null, attrName);
                                    pluginMap.put(attrName, attrVal);
                                }
                                continue block11;
                            }
                            case AUTHOR: 
                            case WEBPAGE: 
                            case DESCRIPTION: 
                            case SHORTDESCRIPTION: 
                            case NEWINVERSION: {
                                String val = reader.getAttributeValue(null, "value");
                                if (val == null) continue block11;
                                pluginMap.put(currentElement.toString().toLowerCase(), val);
                                break block0;
                            }
                            default: {
                                throw new IOException("Invalid plugin repository xml at " + repositoryURL);
                            }
                        }
                    }
                    case 2: {
                        if (reader.getName().toString().equalsIgnoreCase(XMLElement.PLUGIN.toString())) {
                            AppInfo ai = this.getAppInfo(pluginMap, repositoryURL);
                            this.appInfo.add(ai);
                            break;
                        }
                        if (currentElement == null || currentText.length() <= 0) continue block11;
                        pluginMap.put(currentElement.toString().toLowerCase(), currentText);
                        break;
                    }
                    case 4: {
                        currentText = currentText + reader.getText().trim().replace("\t", "");
                        break;
                    }
                    case 8: {
                        reader.close();
                        reader = null;
                    }
                }
            } while (reader != null);
        }
        LOG.info((Object)("Found " + this.appInfo.size() + " App descriptions"));
    }

    @Override
    public List<AppInfo> fetchApplicationInformation(String search) throws Exception {
        if (this.appInfo == null) {
            this.refreshAppInfo(WebResources.PLUGIN_REPOSITORY_URLS);
        }
        if (search == null || search.length() < 1) {
            return this.appInfo;
        }
        LinkedList<AppInfo> results = new LinkedList<AppInfo>();
        for (AppInfo ai : this.appInfo) {
            if (!ai.getName().contains(search) || !VersionSettings.isAppSDKCompatibleWithClient(ai.getSDKVersion(), VersionSettings.getVersionString())) continue;
            results.add(ai);
        }
        for (AppInfo ai : this.appInfo) {
            if (!ai.getDescription().contains(search) && !ai.getShortDescription().contains(search) && !ai.getNewInVersion().contains(search) || !VersionSettings.isAppSDKCompatibleWithClient(ai.getSDKVersion(), VersionSettings.getVersionString())) continue;
            results.add(ai);
        }
        return results;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("USAGE: MedSavantAppFetcher <URLs to test>");
            System.err.println("Local files can be specified using file:// (e.g. file:///tmp/pluginDirectory.xml)");
        }
        try {
            MedSavantAppFetcher m = new MedSavantAppFetcher();
            m.refreshAppInfo(args);
        }
        catch (Exception ex) {
            System.err.println("Exception caught " + ex);
            ex.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private static enum XMLPluginAttribute {
        URL,
        NAME,
        VERSION,
        SDK_VERSION{

            public String toString() {
                return "sdk-version";
            }
        }
        ,
        CATEGORY;

    }

    private static enum XMLElement {
        PLUGINS,
        PLUGIN,
        AUTHOR,
        WEBPAGE,
        DESCRIPTION,
        SHORTDESCRIPTION,
        NEWINVERSION,
        ERROR;

    }
}

