/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.component.field.editable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import org.ut.biolab.medsavant.component.field.editable.EditableField;

public abstract class OnClickEditableField<T>
extends EditableField<T> {
    private JLabel invalidLabel;
    private boolean extenderShouldBeInitialized = false;
    private boolean passwordField;
    private boolean acceptButtonVisible;
    private boolean rejectButtonVisible;
    private T value;
    private JPanel editorPlaceholder;
    private JLabel valueLabel;
    private JButton rejectChangesButton;
    private JButton acceptChangesButton;

    protected JButton generateRejectButton(final EditableField field) {
        JButton b = EditableField.createSegmentButton("segmentedRoundRect", "first");
        b.setText("Cancel");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                field.setEditing(false);
            }
        });
        b.setFocusable(false);
        return b;
    }

    protected JButton generateAcceptButton(EditableField field) {
        JButton b = EditableField.createSegmentButton("segmentedRoundRect", "last");
        b.setText("OK");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OnClickEditableField.this.saveWithValidationWarning();
                OnClickEditableField.this.setEditing(false);
            }
        });
        b.setFocusable(false);
        return b;
    }

    protected JButton generateEditButton(final EditableField field) {
        JButton b = new JButton("Edit");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                field.setEditing(true);
            }
        });
        b.setFocusable(false);
        return b;
    }

    public abstract void updateEditorRepresentationForValue(T var1);

    public abstract JComponent getEditor();

    @Override
    public abstract T getValueFromEditor();

    public abstract void didToggleEditMode(boolean var1);

    public OnClickEditableField() {
        this(false);
    }

    public OnClickEditableField(boolean passwordField) {
        this.passwordField = passwordField;
        this.initUI();
        this.setValue(null);
        this.updateUIForEditingState(this.isEditing());
        this.updateUIForAutonomousEditingState(this.isAutonomousEditingEnabled());
        this.setAcceptButtonVisible(false);
        this.setRejectButtonVisible(true);
        this.extenderShouldBeInitialized = true;
    }

    @Override
    protected void updateUIForEditingState(boolean isEditing) {
        this.updateUIForEditingState(isEditing, false);
    }

    protected void updateUIForEditingState(boolean isEditing, boolean requestFocus) {
        this.setVisibility(new Component[]{this.valueLabel}, !isEditing);
        this.setVisibility(new Component[]{this.editorPlaceholder}, isEditing);
        if (this.acceptButtonVisible) {
            this.acceptChangesButton.setVisible(isEditing && this.isAutonomousEditingEnabled());
        }
        if (this.rejectButtonVisible) {
            this.rejectChangesButton.setVisible(isEditing && this.isAutonomousEditingEnabled());
        }
        if (isEditing) {
            this.updateEditorRepresentationForValue(this.value);
            this.editorPlaceholder.removeAll();
            JComponent c = this.getEditor();
            this.editorPlaceholder.add(c);
            c.requestFocus();
            this.editorPlaceholder.updateUI();
        }
        this.didToggleEditMode(isEditing);
    }

    @Override
    protected void updateUIForAutonomousEditingState(boolean isAutonomous) {
        if (isAutonomous) {
            OnClickEditableField.addEditOnClickListener(this, this.valueLabel);
        } else {
            this.removeClickListeners(this.valueLabel);
        }
    }

    @Override
    public void setValue(T v) {
        this.value = v;
        if (v == null || v.toString().isEmpty()) {
            this.valueLabel.setForeground(this.nullColor);
            this.valueLabel.setText("Not Set ");
            this.valueLabel.setFont(this.valueLabel.getFont().deriveFont(2));
        } else {
            this.valueLabel.setForeground(Color.black);
            String strRepresentation = v.toString();
            if (this.passwordField) {
                strRepresentation = this.passwordStringOfLength(strRepresentation.length());
            }
            this.valueLabel.setText(strRepresentation);
            this.valueLabel.setFont(this.valueLabel.getFont().deriveFont(0));
        }
        if (this.extenderShouldBeInitialized) {
            this.updateEditorRepresentationForValue(this.value);
        }
    }

    private String passwordStringOfLength(int length) {
        String s = "";
        while (length-- > 0) {
            s = s + "\u2022";
        }
        return s;
    }

    @Override
    public T getValue() {
        if (this.isEditing()) {
            return this.getValueFromEditor();
        }
        return this.value;
    }

    private void initUI() {
        this.setLayout((LayoutManager)new MigLayout("insets 0, hidemode 3, gapx 0, gapy 1"));
        this.valueLabel = new JLabel(){
            int maxChars = 30;

            @Override
            public void setText(String s) {
                if (s.length() > this.maxChars) {
                    this.setToolTipText(s);
                    super.setText(s.substring(0, this.maxChars - 3) + "...");
                } else {
                    super.setText(s);
                    this.setToolTipText(null);
                }
            }
        };
        this.valueLabel.setFocusable(true);
        this.editorPlaceholder = new JPanel();
        this.editorPlaceholder.setOpaque(false);
        this.editorPlaceholder.setLayout((LayoutManager)new MigLayout("insets 0, hidemode 3"));
        this.add(this.valueLabel);
        this.add(this.editorPlaceholder);
        this.rejectChangesButton = this.generateRejectButton(this);
        this.acceptChangesButton = this.generateAcceptButton(this);
        this.add(this.rejectChangesButton);
        this.add(this.acceptChangesButton);
        this.rejectChangesButton.setVisible(false);
        this.acceptChangesButton.setVisible(false);
        Font font = this.valueLabel.getFont();
        Map<TextAttribute, ?> attributes = font.getAttributes();
        this.valueLabel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (OnClickEditableField.this.isAutonomousEditingEnabled()) {
                    OnClickEditableField.this.valueLabel.setForeground(OnClickEditableField.this.editColor);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (OnClickEditableField.this.isAutonomousEditingEnabled()) {
                    if (OnClickEditableField.this.value == null || OnClickEditableField.this.value.toString().isEmpty()) {
                        OnClickEditableField.this.valueLabel.setForeground(OnClickEditableField.this.nullColor);
                    } else {
                        OnClickEditableField.this.valueLabel.setForeground(Color.black);
                    }
                }
            }
        });
        this.invalidLabel = new JLabel();
        this.invalidLabel.setForeground(Color.red);
        this.invalidLabel.setFont(this.invalidLabel.getFont().deriveFont(0).deriveFont(10.0f));
        this.add((Component)this.invalidLabel, "newline");
    }

    private void setVisibility(Component[] components, boolean isVisible) {
        for (Component c : components) {
            c.setVisible(isVisible);
        }
    }

    private void removeClickListeners(JLabel valueLabel) {
        for (MouseListener ml : valueLabel.getMouseListeners()) {
            valueLabel.removeMouseListener(ml);
        }
    }

    public void addSaveFocusListener(JComponent c) {
        c.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (OnClickEditableField.this.isAutonomousEditingEnabled()) {
                    OnClickEditableField.this.saveWithValidationWarning();
                    OnClickEditableField.this.setEditing(false);
                }
            }
        });
    }

    @Override
    public boolean validateCurrentValue() {
        boolean result = super.validateCurrentValue();
        if (this.getValidator() != null) {
            String description = this.getValidator().getDescriptionOfValidValue();
            this.invalidLabel.setText(description);
            this.invalidLabel.setVisible(!result);
        } else {
            this.invalidLabel.setText("");
        }
        return result;
    }

    void saveWithValidationWarning() {
        if (!this.isEditing()) {
            return;
        }
        if (this.setValueFromEditor()) {
            this.invalidLabel.setVisible(false);
        } else {
            String description = this.getValidator().getDescriptionOfValidValue();
            this.invalidLabel.setText(description);
            this.invalidLabel.setVisible(true);
        }
    }

    @Override
    public void setEditing(boolean isEditing) {
        super.setEditing(isEditing);
        this.invalidLabel.setVisible(false);
        this.updateUI();
    }

    public void addFieldChangeKeyListener(JTextField fieldToListenOn) {
        fieldToListenOn.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                OnClickEditableField.this.fireFieldEditedEvent();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                OnClickEditableField.this.fireFieldEditedEvent();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                OnClickEditableField.this.fireFieldEditedEvent();
            }
        });
    }

    public void addSaveAndCancelKeyListeners(JComponent c) {
        c.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (OnClickEditableField.this.isAutonomousEditingEnabled()) {
                    if (e.getKeyChar() == '\n' || e.getKeyChar() == '\t') {
                        OnClickEditableField.this.saveWithValidationWarning();
                        OnClickEditableField.this.setEditing(false);
                        return;
                    }
                    if (e.getKeyChar() == '\u001b') {
                        OnClickEditableField.this.setEditing(false);
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
    }

    public void setRejectButtonVisible(boolean b) {
        this.rejectButtonVisible = b;
        if (b && this.editing) {
            this.rejectChangesButton.setVisible(b);
        }
        this.updateButtonPositions();
    }

    @Override
    public void setAutonomousEditingEnabled(boolean b) {
        super.setAutonomousEditingEnabled(b);
        if (!b) {
            this.acceptChangesButton.setVisible(false);
            this.rejectChangesButton.setVisible(false);
        }
    }

    public void setAcceptButtonVisible(boolean b) {
        this.acceptButtonVisible = b;
        if (b && this.editing) {
            this.acceptChangesButton.setVisible(b);
        }
        this.updateButtonPositions();
    }

    private void updateButtonPositions() {
        if (this.rejectChangesButton.isVisible() && this.acceptChangesButton.isVisible()) {
            this.rejectChangesButton.putClientProperty("JButton.segmentPosition", "first");
            this.acceptChangesButton.putClientProperty("JButton.segmentPosition", "last");
        } else {
            this.rejectChangesButton.putClientProperty("JButton.segmentPosition", "only");
            this.acceptChangesButton.putClientProperty("JButton.segmentPosition", "only");
        }
    }
}

