/*
 * Decompiled with CFR 0.152.
 */
package mfiume.component.transition;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import mfiume.component.transition.Animator;

public class JTransitionPanel
extends JPanel {
    private static final float DEFAULT_SLIDE_DURATION = 50.0f;
    private final JLayeredPane layers;
    private JPanel currentPanel = null;
    private final JPanel placeHolderOne;
    private final JPanel placeHolderTwo;
    private final JPanel animationCanvas;

    private void addPanelAndFill(JComponent child, JComponent parent) {
        parent.removeAll();
        parent.setLayout(new BorderLayout());
        parent.add((Component)child, "Center");
        parent.updateUI();
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
    }

    public JTransitionPanel() {
        this.setDoubleBuffered(true);
        this.layers = new JLayeredPane();
        this.addPanelAndFill(this.layers, this);
        this.placeHolderOne = new JPanel();
        this.placeHolderTwo = new JPanel();
        this.animationCanvas = new JPanel(){

            @Override
            public void paintComponent(Graphics g) {
                System.out.println("Flash");
            }
        };
        this.animationCanvas.setOpaque(false);
        this.layers.add(this.placeHolderOne, 0, 0);
        this.layers.add(this.placeHolderTwo, 1, 0);
        this.layers.add(this.animationCanvas, 2, 0);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                JTransitionPanel.this.rebound();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    private void rebound() {
        for (Component c : this.layers.getComponents()) {
            c.setBounds(this.layers.getBounds());
        }
        this.updateUI();
    }

    public void push(final JPanel newPanel, TransitionType type, final ActionListener doneListener) {
        ActionListener uberListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JTransitionPanel instance = JTransitionPanel.this;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JTransitionPanel.this.placeHolderOne.removeAll();
                        JTransitionPanel.this.addPanelAndFill(newPanel, JTransitionPanel.this.placeHolderTwo);
                        JTransitionPanel.this.animationCanvas.setVisible(false);
                        instance.setBackground(JTransitionPanel.this.placeHolderTwo.getBackground());
                        instance.updateUI();
                    }
                });
                if (doneListener != null) {
                    doneListener.actionPerformed(e);
                }
            }
        };
        Point origin = new Point(0, 0);
        switch (type) {
            case SLIDE_LEFT: {
                Animator.animateSlide(this.animationCanvas, this.currentPanel, newPanel, 50.0f, uberListener, new Point(this.getWidth(), 0), origin);
                break;
            }
            case SLIDE_RIGHT: {
                Animator.animateSlide(this.animationCanvas, this.currentPanel, newPanel, 50.0f, uberListener, new Point(-this.getWidth(), 0), origin);
                break;
            }
            case SLIDE_UP: {
                Animator.animateSlide(this, this.currentPanel, newPanel, 50.0f, uberListener, new Point(0, this.getHeight()), origin);
                break;
            }
            case SLIDE_DOWN: {
                Animator.animateSlide(this.animationCanvas, this.currentPanel, newPanel, 50.0f, uberListener, new Point(0, -this.getHeight()), origin);
                break;
            }
            case PUSH_LEFT: {
                Animator.animatePush(this.animationCanvas, this.currentPanel, newPanel, 50.0f, uberListener, new Point(this.getWidth(), 0), origin);
                break;
            }
            case PUSH_RIGHT: {
                Animator.animatePush(this.animationCanvas, this.currentPanel, newPanel, 50.0f, uberListener, new Point(-this.getWidth(), 0), origin);
                break;
            }
            case PUSH_UP: {
                Animator.animatePush(this.animationCanvas, this.currentPanel, newPanel, 50.0f, uberListener, new Point(0, this.getHeight()), origin);
                break;
            }
            case PUSH_DOWN: {
                Animator.animatePush(this.animationCanvas, this.currentPanel, newPanel, 50.0f, uberListener, new Point(0, -this.getHeight()), origin);
                break;
            }
            case FADE_IN: {
                Animator.animateAlpha(this.animationCanvas, this.currentPanel, newPanel, 50.0f, uberListener, Float.valueOf(0.0f), Float.valueOf(1.0f));
                break;
            }
            case FADE_OUT: {
                Animator.animateAlpha(this.animationCanvas, newPanel, this.currentPanel, 50.0f, uberListener, Float.valueOf(1.0f), Float.valueOf(0.0f));
                break;
            }
            case NONE: {
                uberListener.actionPerformed(null);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Transition " + (Object)((Object)type) + " not supported yet");
            }
        }
        this.currentPanel = newPanel;
    }

    public static void main(String[] v) {
        final JTransitionPanel p = new JTransitionPanel();
        final JPanel red = new JPanel();
        red.setBackground(new Color(60, 60, 60));
        final JPanel yellow = new JPanel();
        yellow.setBackground(new Color(100, 100, 100));
        p.push(red, TransitionType.NONE, null);
        JButton doIt = new JButton("Do it");
        red.add(doIt);
        doIt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                p.push(yellow, TransitionType.PUSH_RIGHT, null);
            }
        });
        for (int i = 0; i < 30; ++i) {
            JButton doIt2 = new JButton("Do it " + i);
            yellow.add(doIt2);
            doIt2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    p.push(red, TransitionType.PUSH_LEFT, null);
                }
            });
        }
        JFrame f = new JFrame();
        f.add(p);
        f.pack();
        f.setVisible(true);
    }

    public static enum TransitionType {
        PUSH_LEFT,
        PUSH_RIGHT,
        PUSH_UP,
        PUSH_DOWN,
        ZOOM_IN,
        ZOOM_OUT,
        SLIDE_LEFT,
        SLIDE_RIGHT,
        SLIDE_UP,
        SLIDE_DOWN,
        FADE_IN,
        FADE_OUT,
        NONE;

    }
}

