/*
 * Decompiled with CFR 0.152.
 */
package mfiume.component.transition;

import aurelienribon.tweenengine.Tween;
import aurelienribon.tweenengine.TweenAccessor;
import aurelienribon.tweenengine.TweenManager;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import mfiume.component.transition.accessor.FloatAccessor;
import mfiume.component.transition.accessor.PointAccessor;
import mfiume.component.transition.painter.AlphaBasedPainterPanel;
import mfiume.component.transition.painter.PositionBasedPainterPanel;

public class Animator {
    private static final int TIMER_UPDATE_FREQUENCY = 2;

    static void animateSlide(final JPanel canvas, JPanel previous, JPanel current, float duration, final ActionListener completionCallback, final Point startPoint, final Point endPoint) {
        final PositionBasedPainterPanel painter = new PositionBasedPainterPanel();
        Tween.registerAccessor(Point.class, (TweenAccessor)new PointAccessor());
        final TweenManager manager = new TweenManager();
        painter.setNewOrigin(startPoint);
        painter.setNewImageSource(current, canvas.getSize());
        final Runnable animationPanelRepainter = new Runnable(){

            @Override
            public void run() {
                Graphics g = canvas.getGraphics();
                painter.paintComponent(g);
                g.dispose();
            }
        };
        Tween.to((Object)startPoint, (int)0, (float)duration).target((float)endPoint.x, (float)endPoint.y).start(manager);
        final long startTime = System.currentTimeMillis();
        Timer animationTimer = new Timer(2, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (startPoint.x == endPoint.x && startPoint.y == endPoint.y) {
                    ((Timer)e.getSource()).stop();
                    ((Timer)e.getSource()).stop();
                    if (completionCallback != null) {
                        completionCallback.actionPerformed(e);
                    }
                    return;
                }
                manager.update((float)(System.currentTimeMillis() - startTime) / 1000.0f);
                try {
                    SwingUtilities.invokeLater(animationPanelRepainter);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        animationTimer.setRepeats(true);
        animationTimer.start();
    }

    static void animatePush(final JPanel canvas, JPanel previous, JPanel current, float duration, final ActionListener completionCallback, final Point startPoint, final Point endPoint) {
        final PositionBasedPainterPanel painter = new PositionBasedPainterPanel();
        Tween.registerAccessor(Point.class, (TweenAccessor)new PointAccessor());
        final TweenManager manager = new TweenManager();
        painter.setNewOrigin(startPoint);
        painter.setNewImageSource(current, canvas.getSize());
        painter.setPreviousImageSource(previous, canvas.getSize());
        final int xDifference = endPoint.x - startPoint.x;
        final int yDifference = endPoint.y - startPoint.y;
        painter.setPreviousOrigin(new Point(){

            @Override
            public double getX() {
                return startPoint.x + xDifference;
            }

            @Override
            public double getY() {
                return startPoint.y + yDifference;
            }
        });
        final Runnable animationPanelRepainter = new Runnable(){

            @Override
            public void run() {
                Graphics g = canvas.getGraphics();
                painter.paintComponent(g);
                g.dispose();
            }
        };
        Tween.to((Object)startPoint, (int)0, (float)duration).target((float)endPoint.x, (float)endPoint.y).start(manager);
        final long startTime = System.currentTimeMillis();
        Timer animationTimer = new Timer(2, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (startPoint.x == endPoint.x && startPoint.y == endPoint.y) {
                    ((Timer)e.getSource()).stop();
                    if (completionCallback != null) {
                        completionCallback.actionPerformed(e);
                    }
                    return;
                }
                manager.update((float)(System.currentTimeMillis() - startTime) / 1000.0f);
                try {
                    SwingUtilities.invokeLater(animationPanelRepainter);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        animationTimer.setRepeats(true);
        animationTimer.start();
    }

    static void animateAlpha(final JPanel canvas, JPanel previous, JPanel current, float duration, final ActionListener completionCallback, Float startAlpha, final Float endAlpha) {
        final AlphaBasedPainterPanel painter = new AlphaBasedPainterPanel();
        Tween.registerAccessor(FloatAccessor.FloatStruct.class, (TweenAccessor)new FloatAccessor());
        final TweenManager manager = new TweenManager();
        final FloatAccessor.FloatStruct struct = new FloatAccessor.FloatStruct(startAlpha.floatValue());
        painter.setNewImageAlpha(struct);
        painter.setNewImageSource(current, canvas.getSize());
        painter.setPreviousImageSource(previous, canvas.getSize());
        final Runnable animationPanelRepainter = new Runnable(){

            @Override
            public void run() {
                Graphics g = canvas.getGraphics();
                painter.paintComponent(g);
                g.dispose();
            }
        };
        Tween.to((Object)struct, (int)0, (float)duration).target(endAlpha.floatValue()).start(manager);
        final long startTime = System.currentTimeMillis();
        Timer animationTimer = new Timer(2, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (struct.getFloat() == endAlpha.floatValue()) {
                    ((Timer)e.getSource()).stop();
                    if (completionCallback != null) {
                        completionCallback.actionPerformed(e);
                    }
                    return;
                }
                manager.update((float)(System.currentTimeMillis() - startTime) / 1000.0f);
                try {
                    SwingUtilities.invokeLater(animationPanelRepainter);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        animationTimer.setRepeats(true);
        animationTimer.start();
    }
}

