/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.validation;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Scanner;

public class QueryExecutor {
    private static String derbyURL = "jdbc:derby:genemania.derby";
    private static String ensemblURL = "jdbc:mysql://localhost:3306/go";
    private static String driver1 = "org.apache.derby.jdbc.EmbeddedDriver";
    private static String driver2 = "com.mysql.jdbc.Driver";
    private static Connection conDerby;
    private static Connection conEnsembl;

    public static void establishConnections() {
        try {
            Class.forName(driver1);
            conDerby = DriverManager.getConnection(derbyURL, "genemania", "password");
            Class.forName(driver2);
            conEnsembl = DriverManager.getConnection(ensemblURL, "genemania", "password");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            System.out.print("JDBC Driver " + driver1 + " not found in CLASSPATH or");
            System.out.println("JDBC Driver " + driver2 + " not found in CLASSPATH");
        }
    }

    public static void close() {
        try {
            if (conDerby != null) {
                conDerby.close();
            }
            if (conEnsembl != null) {
                conEnsembl.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static ResultSet executeDerbyQuery(String query) {
        try {
            Statement stmt = conDerby.createStatement();
            return stmt.executeQuery(query);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ResultSet executeEnsemblQuery(String query) {
        try {
            Statement stmt = conEnsembl.createStatement();
            return stmt.executeQuery(query);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String[] getGOInfo(String goID) {
        try {
            ResultSet rs = QueryExecutor.executeEnsemblQuery("SELECT name, term_type FROM term WHERE acc = \"" + goID + "\"");
            rs.next();
            String[] s = new String[]{rs.getString(1), rs.getString(2)};
            return s;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String[] getBatchStats(String batchFileFolder, String orgName, String goID) {
        try {
            Scanner sc = new Scanner(new File(batchFileFolder + "/" + orgName + ".batch.txt"));
            String[] batchStats = new String[3];
            while (sc.hasNextLine()) {
                String line = sc.nextLine();
                String[] tokens = line.split("\t");
                if (!tokens[0].startsWith(goID) || !tokens[1].startsWith("-")) continue;
                batchStats[0] = tokens[2].substring(0, tokens[2].length() - 1);
                batchStats[1] = tokens[3].substring(0, tokens[3].length() - 1);
                batchStats[2] = tokens[4];
                return batchStats;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            Scanner sc = new Scanner(new File(args[0] + "/" + args[1]));
            QueryExecutor.establishConnections();
            System.out.println("Node ID\tGene Symbols\tOrg Name\tGO ID\tGO Name\tGO Hierarchy\tAUC-ROC\tAUC-PR\tPR-10\tScore (DV)\tPercentile\tDescription");
            while (sc.hasNextLine()) {
                String line = sc.nextLine();
                String[] tokens = line.split("\t");
                String goID = tokens[0];
                for (String token : tokens) {
                    if (token.startsWith("GO")) continue;
                    try {
                        String[] stats = token.split(":");
                        String negID = stats[0];
                        String query = "SELECT N.ID, Symbol, Organism_ID, GENE_DATA_ID, G.Naming_Source_ID FROM NODES N INNER JOIN GENES G ON N.ID = G.NODE_ID WHERE N.ID = " + negID;
                        ResultSet rs = QueryExecutor.executeDerbyQuery(query);
                        int nodeID = -1;
                        int orgID = -1;
                        int geneDataID = -1;
                        ArrayList<String> symbols = new ArrayList<String>();
                        while (rs.next()) {
                            nodeID = rs.getInt(1);
                            symbols.add(rs.getString(2));
                            orgID = rs.getInt(3);
                            geneDataID = rs.getInt(4);
                        }
                        query = "SELECT Symbol, G.Naming_Source_ID FROM NODES N INNER JOIN GENES G ON N.ID = G.NODE_ID WHERE G.Naming_Source_ID in (5, 2) and N.ID = " + negID + " ORDER BY G.Naming_Source_ID";
                        rs = QueryExecutor.executeDerbyQuery(query);
                        while (rs.next()) {
                            String symbol = rs.getString(1);
                            symbols.remove(symbol);
                            symbols.add(0, symbol);
                        }
                        String geneNames = "";
                        for (String s : symbols) {
                            geneNames = geneNames + s + " | ";
                        }
                        geneNames = geneNames.substring(0, geneNames.length() - 3);
                        String[] goInfo = QueryExecutor.getGOInfo(goID);
                        query = "SELECT Name FROM ORGANISMS WHERE ID = " + orgID;
                        rs = QueryExecutor.executeDerbyQuery(query);
                        rs.next();
                        String orgName = rs.getString(1);
                        String[] batchStats = QueryExecutor.getBatchStats(args[0], orgName, goID);
                        query = "SELECT Description FROM GENE_DATA WHERE ID = " + geneDataID;
                        ResultSet geneDescr = QueryExecutor.executeDerbyQuery(query);
                        geneDescr.next();
                        System.out.println(nodeID + "\t" + geneNames + "\t" + orgName + "\t" + goID + "\t" + goInfo[0] + "\t" + goInfo[1] + "\t" + batchStats[0] + "\t" + batchStats[1] + "\t" + batchStats[2] + "\t" + stats[1] + "\t" + stats[2] + "\t" + geneDescr.getString(1));
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            QueryExecutor.close();
        }
    }
}

