/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.summary;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.domain.Organism;
import org.genemania.engine.apps.support.DataConnector;
import org.genemania.engine.core.data.Network;
import org.genemania.engine.core.data.NodeIds;
import org.genemania.engine.summary.NetworkStats;
import org.genemania.engine.summary.PreferredNames;
import org.genemania.engine.summary.Reporter;
import org.genemania.engine.summary.ReporterFactory;
import org.genemania.engine.summary.Summarizer;
import org.genemania.exception.ApplicationException;

public class NetworksSummarizer
implements Summarizer {
    private static Logger logger = Logger.getLogger(NetworksSummarizer.class);
    Organism organism;
    DataConnector dataConnector;
    PreferredNames preferredNames;
    Map<String, Integer> countsByGroup;
    int uniqueNetworks;
    Reporter networkReporter;
    Reporter networkDegreeReporter;

    public NetworksSummarizer(Organism organism, DataConnector dataConnector) throws Exception {
        this.organism = organism;
        this.dataConnector = dataConnector;
        this.preferredNames = new PreferredNames(organism.getId(), dataConnector, "Entrez Gene ID", "Ensembl Gene ID", "TAIR ID", "Gene Name", "Entrez Gene Name", "Ensembl Gene Name", "Ensembl Protein ID", "Uniprot ID");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void summarize(ReporterFactory reporterFactory) throws Exception {
        logger.info((Object)String.format("summarizing networks for organism %d - %s", this.organism.getId(), this.organism.getName()));
        this.networkReporter = reporterFactory.getReporter("networks");
        this.networkDegreeReporter = reporterFactory.getReporter("networkDegrees");
        try {
            this.networkReporter.init("Network Group ID", "Network Group Name", "Network ID", "Network Name", "Num Nodes", "Num Edges", "Source", "Source URL");
            this.networkDegreeReporter.init("Network ID", "Node ID", "Symbol", "Degree", "Interactors");
            Collection groups = this.organism.getInteractionNetworkGroups();
            for (InteractionNetworkGroup group : groups) {
                this.summerizeGroup(group);
            }
        }
        finally {
            this.networkDegreeReporter.close();
            this.networkReporter.close();
        }
    }

    void summerizeGroup(InteractionNetworkGroup group) throws ApplicationException {
        Collection networks = group.getInteractionNetworks();
        String groupName = group.getName();
        int numNetworks = networks.size();
        this.countsByGroup.put(groupName, numNetworks);
        for (InteractionNetwork network : networks) {
            this.summarizeNetwork(network, group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportGroups(ReporterFactory reporterFactory) throws Exception {
        Reporter reporter = reporterFactory.getReporter("network_groups");
        try {
            reporter.init("Group name", "# of networks");
            ArrayList<String> allGroups = new ArrayList<String>();
            allGroups.addAll(this.countsByGroup.keySet());
            Collections.sort(allGroups);
            int numGroups = allGroups.size();
            int numNetworks = 0;
            for (String group : allGroups) {
                int count = this.countsByGroup.get(group);
                numNetworks += count;
                reporter.write(group, "" + count);
            }
            reporter.write("total networks", "" + numNetworks);
            reporter.write("total groups", "" + numGroups);
        }
        finally {
            reporter.close();
        }
    }

    void reportNetworks(ReporterFactory reporterFactory) throws Exception {
    }

    void summarizeNetwork(InteractionNetwork network, InteractionNetworkGroup group) throws ApplicationException {
        NetworkStats stats;
        Network networkData = this.dataConnector.getCache().getNetwork("CORE", this.organism.getId(), network.getId());
        long expectedNumInteractions = network.getMetadata().getInteractionCount();
        if (expectedNumInteractions != (long)(stats = new NetworkStats(networkData)).getNumEdges()) {
            logger.warn((Object)String.format("inconsistent number of interactions in network %d - %s (expected %d got %d)", network.getId(), network.getName(), expectedNumInteractions, stats.getNumEdges()));
        }
        network.getMetadata().getSource();
        this.networkReporter.write("" + group.getId(), group.getName(), "" + network.getId(), network.getName(), "" + stats.getNumInteractingNodes(), "" + stats.getNumEdges(), network.getMetadata().getSource(), network.getMetadata().getSourceUrl());
        List<GeneDataHolder> holders = this.buildOrderedGeneList(stats);
        for (GeneDataHolder holder : holders) {
            this.networkDegreeReporter.write("" + network.getId(), "" + holder.nodeId, holder.name, "" + holder.degree, "" + holder.numInteractors);
        }
    }

    List<GeneDataHolder> buildOrderedGeneList(NetworkStats stats) throws ApplicationException {
        NodeIds nodeIds = this.dataConnector.getCache().getNodeIds(this.organism.getId());
        ArrayList<GeneDataHolder> holders = new ArrayList<GeneDataHolder>();
        for (int i = 0; i < stats.getNodeDegrees().getSize(); ++i) {
            double degree = stats.getNodeDegrees().get(i);
            if (!(degree > 0.0)) continue;
            long nodeId = nodeIds.getIdForIndex(i);
            GeneDataHolder holder = new GeneDataHolder();
            holder.nodeId = nodeId;
            holder.name = this.preferredNames.getName(nodeId);
            holder.degree = degree;
            holder.numInteractors = stats.getNodeInteractorsCount()[i];
            holders.add(holder);
        }
        Collections.sort(holders, HolderComparator.getInstance());
        return holders;
    }

    @Override
    public void setUp() throws Exception {
        this.countsByGroup = new HashMap<String, Integer>();
        this.uniqueNetworks = 0;
    }

    @Override
    public void tearDown() throws Exception {
    }

    static class HolderComparator
    implements Comparator<GeneDataHolder> {
        static HolderComparator instance = new HolderComparator();

        HolderComparator() {
        }

        @Override
        public int compare(GeneDataHolder arg0, GeneDataHolder arg1) {
            return Collator.getInstance().compare(arg0.name, arg1.name);
        }

        public static HolderComparator getInstance() {
            return instance;
        }
    }

    static class GeneDataHolder {
        String name;
        long nodeId;
        double degree;
        int numInteractors;

        GeneDataHolder() {
        }
    }
}

