/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.summary;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.genemania.engine.summary.Reporter;
import org.genemania.exception.ApplicationException;

public class GMTReporter
implements Reporter {
    public static final String ENCODING = "UTF8";
    public static final char FIELD_SEP = '\t';
    public static final char QUOTE_CHAR = '\u0000';
    File file;
    CSVWriter writer;
    List<String> fieldNames;

    public GMTReporter(String location) throws IOException {
        this.file = new File(location);
        File dir = this.file.getParentFile();
        if (dir != null && !dir.isDirectory() && !dir.exists()) {
            dir.mkdirs();
        }
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), ENCODING));
        this.writer = new CSVWriter((Writer)out, '\t', '\u0000');
    }

    @Override
    public String getReportName() {
        return this.file.getName();
    }

    @Override
    public void init(List<String> fieldNames) throws ApplicationException {
    }

    @Override
    public void init(String ... fieldNames) throws ApplicationException {
    }

    @Override
    public void write(List<String> fieldValues) throws ApplicationException {
        this.write(fieldValues.toArray(new String[fieldValues.size()]));
    }

    @Override
    public void write(String ... fieldValues) throws ApplicationException {
        this.writer.writeNext(fieldValues);
    }

    @Override
    public void write(Map<String, String> record) throws ApplicationException {
        throw new ApplicationException("not implemented");
    }

    @Override
    public void close() throws ApplicationException {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new ApplicationException("failed to close", (Throwable)e);
        }
    }
}

