/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.matricks.custom;

import org.genemania.engine.matricks.MatricksException;
import org.genemania.engine.matricks.MatrixCursor;
import org.genemania.engine.matricks.SymMatrix;
import org.genemania.engine.matricks.custom.AbstractMatrix;

public class SymMatrixView
extends AbstractMatrix
implements SymMatrix {
    private static final long serialVersionUID = -1085410256279321744L;
    SymMatrix backing;
    int[] indices;

    public SymMatrixView(SymMatrix backing, int[] indices) {
        this.backing = backing;
        this.indices = indices;
    }

    @Override
    public int numRows() {
        return this.indices.length;
    }

    @Override
    public int numCols() {
        return this.indices.length;
    }

    @Override
    public double get(int row, int col) {
        return this.backing.get(this.indices[row], this.indices[col]);
    }

    @Override
    public void set(int row, int col, double val) throws MatricksException {
        throw new MatricksException("read-only");
    }

    @Override
    public MatrixCursor cursor() {
        return new SymMatrixViewCursor();
    }

    @Override
    public void multAdd(double alpha, double[] x, double[] y) {
        throw new MatricksException("not implemented");
    }

    @Override
    public void mult(double[] x, double[] y) {
        throw new MatricksException("not implemented");
    }

    @Override
    public SymMatrix subMatrix(int[] rowcols) {
        throw new MatricksException("not implemented");
    }

    @Override
    public void setDiag(double alpha) {
        throw new MatricksException("not implemented");
    }

    @Override
    public void addOuterProd(double[] x) {
        throw new MatricksException("not implemented");
    }

    @Override
    public double sumDotMultOuterProd(double[] x) {
        throw new MatricksException("not implemented");
    }

    private class SymMatrixViewCursor
    implements MatrixCursor {
        int i = 0;
        int j = -1;
        final int k;

        public SymMatrixViewCursor() {
            this.k = SymMatrixView.this.indices.length - 1;
        }

        @Override
        public boolean next() {
            if (this.j == this.k) {
                if (this.i < this.k) {
                    ++this.i;
                    this.j = 0;
                    return true;
                }
                return false;
            }
            ++this.j;
            return true;
        }

        @Override
        public int row() {
            return this.i;
        }

        @Override
        public int col() {
            return this.j;
        }

        @Override
        public double val() {
            return SymMatrixView.this.get(this.i, this.j);
        }

        @Override
        public void set(double val) {
            throw new MatricksException("read-only");
        }
    }
}

