/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.matricks.custom;

import org.genemania.engine.matricks.MatricksException;
import org.genemania.engine.matricks.Matrix;
import org.genemania.engine.matricks.MatrixCursor;
import org.genemania.engine.matricks.SymMatrix;
import org.genemania.engine.matricks.custom.AbstractMatrix;

public class OuterProductSymMatrixFromMatrixColView
extends AbstractMatrix
implements SymMatrix {
    private static final long serialVersionUID = 6552288568343974052L;
    final Matrix backing;
    final int backingCol;
    double scale;
    boolean zeroDiag;

    public OuterProductSymMatrixFromMatrixColView(Matrix backing, int backingCol, double scale, boolean zeroDiag) {
        this.backing = backing;
        this.backingCol = backingCol;
        this.scale = scale;
        this.zeroDiag = zeroDiag;
    }

    @Override
    public int numRows() {
        return this.backing.numRows();
    }

    @Override
    public int numCols() {
        return this.backing.numRows();
    }

    @Override
    public double get(int row, int col) {
        if (this.zeroDiag && row == col) {
            return 0.0;
        }
        return this.scale * this.backing.get(row, this.backingCol) * this.backing.get(col, this.backingCol);
    }

    @Override
    public void set(int row, int col, double val) throws MatricksException {
        throw new MatricksException("read only view");
    }

    @Override
    public MatrixCursor cursor() {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void multAdd(double alpha, double[] x, double[] y) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void mult(double[] x, double[] y) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public SymMatrix subMatrix(int[] rowcols) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void setDiag(double alpha) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void addOuterProd(double[] x) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public double sumDotMultOuterProd(double[] x) {
        throw new MatricksException("Not implemented");
    }

    public Matrix getMatrixView(int[] rowIndices, int[] colIndices) {
        return null;
    }
}

