/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.matricks.custom;

import no.uib.cipr.matrix.DenseVector;
import org.genemania.engine.core.MatrixUtils;
import org.genemania.engine.matricks.MatricksException;
import org.genemania.engine.matricks.MatrixCursor;
import org.genemania.engine.matricks.SymMatrix;
import org.genemania.engine.matricks.Vector;
import org.genemania.engine.matricks.custom.AbstractMatrix;
import org.genemania.engine.matricks.custom.DenseDoubleVector;

public class EyePlusLaplacianMatrix
extends AbstractMatrix
implements SymMatrix {
    private static final long serialVersionUID = 4350267948942777088L;
    SymMatrix backing;
    DenseVector diag;

    public EyePlusLaplacianMatrix(SymMatrix backing) {
        this.backing = backing;
        this.computeDiag();
    }

    private void computeDiag() {
        this.diag = new DenseVector(this.backing.numRows());
        this.backing.rowSums(this.diag.getData());
        MatrixUtils.add((no.uib.cipr.matrix.Vector)this.diag, 1.0);
    }

    @Override
    public int numRows() {
        return this.backing.numRows();
    }

    @Override
    public int numCols() {
        return this.backing.numCols();
    }

    @Override
    public double get(int row, int col) {
        if (row == col) {
            return this.diag.get(row);
        }
        return -this.backing.get(row, col);
    }

    @Override
    public void set(int row, int col, double val) throws MatricksException {
        throw new MatricksException("read-only");
    }

    @Override
    public MatrixCursor cursor() {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void multAdd(double alpha, Vector x, Vector y) {
        if (!(x instanceof DenseDoubleVector) || !(y instanceof DenseDoubleVector)) {
            throw new MatricksException("Not implemented");
        }
        DenseDoubleVector xx = (DenseDoubleVector)x;
        DenseDoubleVector yy = (DenseDoubleVector)y;
        this.multAdd(xx.data, yy.data);
    }

    @Override
    public void mult(Vector x, Vector y) {
        if (!(x instanceof DenseDoubleVector) || !(y instanceof DenseDoubleVector)) {
            throw new MatricksException("Not implemented");
        }
        DenseDoubleVector xx = (DenseDoubleVector)x;
        DenseDoubleVector yy = (DenseDoubleVector)y;
        this.mult(xx.data, yy.data);
    }

    @Override
    public void multAdd(double alpha, double[] x, double[] y) {
        int i;
        int l = this.backing.numRows();
        for (i = 0; i < l; ++i) {
            y[i] = -y[i];
        }
        this.backing.multAdd(x, y);
        for (i = 0; i < l; ++i) {
            y[i] = this.diag.get(i) * x[i] - y[i];
        }
    }

    @Override
    public void mult(double[] x, double[] y) {
        int i;
        int l = this.backing.numRows();
        for (i = 0; i < l; ++i) {
            y[i] = -y[i];
        }
        this.backing.mult(x, y);
        for (i = 0; i < l; ++i) {
            y[i] = this.diag.get(i) * x[i] - y[i];
        }
    }

    @Override
    public SymMatrix subMatrix(int[] rowcols) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public void setDiag(double alpha) {
        throw new MatricksException("read-only");
    }

    @Override
    public void addOuterProd(double[] x) {
        throw new MatricksException("Not implemented");
    }

    @Override
    public double sumDotMultOuterProd(double[] x) {
        throw new MatricksException("Not implemented");
    }
}

