/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.matricks;

import java.io.IOException;
import java.io.Serializable;
import org.genemania.engine.matricks.MatricksException;
import org.genemania.engine.matricks.MatrixAccumulator;
import org.genemania.engine.matricks.MatrixCursor;
import org.genemania.engine.matricks.Vector;

public interface Matrix
extends Serializable {
    public int numRows();

    public int numCols();

    public double get(int var1, int var2);

    public void set(int var1, int var2, double var3) throws MatricksException;

    public void scale(double var1) throws MatricksException;

    public void setAll(double var1) throws MatricksException;

    public MatrixCursor cursor();

    public void add(Matrix var1) throws MatricksException;

    public void add(double var1, Matrix var3) throws MatricksException;

    public double elementSum();

    public double elementMultiplySum(Matrix var1) throws MatricksException;

    public void CG(Vector var1, Vector var2) throws MatricksException;

    public void QR(Vector var1, Vector var2) throws MatricksException;

    public Vector rowSums() throws MatricksException;

    public Vector columnSums() throws MatricksException;

    public void rowSums(double[] var1) throws MatricksException;

    public void columnSums(double[] var1) throws MatricksException;

    public void setToMaxTranspose() throws MatricksException;

    public void multAdd(double var1, Vector var3, Vector var4);

    public void mult(Vector var1, Vector var2);

    public Matrix subMatrix(int[] var1, int[] var2);

    public void add(int var1, int var2, double var3);

    public void mult(double[] var1, double[] var2);

    public void multAdd(double[] var1, double[] var2);

    public void transMult(double[] var1, double[] var2);

    public void compact();

    public MatrixAccumulator accumulator();

    public void mmwrite(String var1) throws IOException;

    public Matrix mmread(String var1) throws IOException;
}

