/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.utils;

import java.util.Iterator;
import java.util.Map;
import org.genemania.engine.core.integration.Feature;
import org.genemania.engine.matricks.MatricksException;
import org.genemania.engine.matricks.SymMatrix;
import org.genemania.engine.matricks.Vector;
import org.genemania.engine.matricks.VectorCursor;

public class Normalization {
    public static void normalizeNetwork(SymMatrix m) throws MatricksException {
        Vector sums = m.columnSums();
        VectorCursor cursor = sums.cursor();
        while (cursor.next()) {
            double val = cursor.val();
            if (val > 0.0) {
                cursor.set(Math.sqrt(val));
                continue;
            }
            cursor.set(1.0);
        }
        m.dotDivOuterProd(sums);
    }

    public static void normalizeFeatureWeights(Map<Feature, Double> featureToWeightMap) {
        double sum = 0.0;
        Iterator<Comparable<Double>> i$ = featureToWeightMap.values().iterator();
        while (i$.hasNext()) {
            double weight = i$.next();
            sum += weight;
        }
        for (Feature feature : featureToWeightMap.keySet()) {
            double weight = featureToWeightMap.get(feature);
            featureToWeightMap.put(feature, weight /= sum);
        }
    }
}

