/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.integration.calculators;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Vector;
import org.apache.log4j.Logger;
import org.genemania.engine.Constants;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.core.data.DataSupport;
import org.genemania.engine.core.data.DatasetInfo;
import org.genemania.engine.core.data.KtK;
import org.genemania.engine.core.data.KtT;
import org.genemania.engine.core.integration.Feature;
import org.genemania.engine.core.integration.FeatureList;
import org.genemania.engine.core.integration.FeatureWeightMap;
import org.genemania.engine.core.integration.INetworkWeightCalculator;
import org.genemania.engine.core.integration.attribute.IAttributeScorer;
import org.genemania.engine.core.integration.attribute.IAttributeSelector;
import org.genemania.engine.core.integration.attribute.TopXOverallSelector;
import org.genemania.engine.core.utils.ObjectSelector;
import org.genemania.engine.matricks.SymMatrix;
import org.genemania.exception.ApplicationException;
import org.genemania.util.ProgressReporter;

public abstract class AbstractNetworkWeightCalculator
implements INetworkWeightCalculator {
    private static Logger logger = Logger.getLogger(AbstractNetworkWeightCalculator.class);
    FeatureWeightMap weights = new FeatureWeightMap();
    Map<Integer, Long> IndexToNetworkIdMap = new HashMap<Integer, Long>();
    SymMatrix combinedMatrix = null;
    String namespace;
    DataCache cache;
    Collection<Collection<Long>> networkIds;
    Collection<Long> attributeGroupIds;
    long organismId;
    Vector label;
    int attributesLimit;
    ProgressReporter progress;

    public AbstractNetworkWeightCalculator(String namespace, DataCache cache, Collection<Collection<Long>> networkIds, Collection<Long> attributeGroupIds, long organismId, Vector label, int attributesLimit, ProgressReporter progress) throws ApplicationException {
        this.namespace = namespace;
        this.cache = cache;
        this.networkIds = networkIds;
        this.attributeGroupIds = attributeGroupIds;
        this.organismId = organismId;
        this.label = label;
        this.attributesLimit = attributesLimit;
        this.progress = progress;
    }

    @Override
    public FeatureWeightMap getWeights() {
        return this.weights;
    }

    @Override
    public SymMatrix getCombinedMatrix() {
        return this.combinedMatrix;
    }

    @Override
    public String getParameterKey() throws ApplicationException {
        throw new ApplicationException("not cacheable");
    }

    DenseMatrix getKtK(boolean hasUserNetworks) throws ApplicationException {
        DenseMatrix KtK2;
        if (!hasUserNetworks) {
            KtK KtKObject = this.cache.getKtK("CORE", this.organismId, Constants.DataFileNames.KtK_BASIC.getCode());
            KtK2 = KtKObject.getData().copy();
        } else {
            KtK KtKObject = this.cache.getKtK(this.namespace, this.organismId, Constants.DataFileNames.KtK_BASIC.getCode());
            KtK2 = KtKObject.getData().copy();
        }
        return KtK2;
    }

    void scaleKtK(DenseMatrix KtK2, String goBranch) throws ApplicationException {
        DatasetInfo info = this.cache.getDatasetInfo(this.organismId);
        int indexForBranch = Constants.getIndexForGoBranch(goBranch);
        int numCategories = info.getNumCategories()[indexForBranch];
        KtK2.scale((double)numCategories);
    }

    DenseMatrix getKtT(String goBranch, boolean hasUserNetworks) throws ApplicationException {
        DenseMatrix KtT2;
        if (!hasUserNetworks) {
            KtT KtTObject = this.cache.getKtT("CORE", this.organismId, goBranch);
            KtT2 = KtTObject.getData();
        } else {
            KtT KtTObject = this.cache.getKtT(this.namespace, this.organismId, goBranch);
            KtT2 = KtTObject.getData();
        }
        return KtT2;
    }

    boolean queryHasUserNetworks() {
        return DataSupport.queryHasUserNetworks(this.networkIds);
    }

    public static String hashString(String target) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.reset();
            digest.update(target.getBytes("iso-8859-1"), 0, target.length());
            byte[] md5sum = digest.digest();
            BigInteger bigInt = new BigInteger(1, md5sum);
            String hex = bigInt.toString(16);
            return hex;
        }
        catch (UnsupportedEncodingException e) {
            return "ENCODING_FAILURE";
        }
        catch (NoSuchAlgorithmException e) {
            return "DIGEST_FAILURE";
        }
    }

    public static String formattedNetworkList(Collection<Collection<Long>> inputNetworks) {
        if (inputNetworks == null || inputNetworks.size() == 0) {
            return "NO_NETWORKS";
        }
        int numGroups = inputNetworks.size();
        Object[] groupLists = new String[numGroups];
        int g = 0;
        for (Collection<Long> group : inputNetworks) {
            ArrayList<Long> sortedGroup = new ArrayList<Long>();
            sortedGroup.addAll(group);
            Collections.sort(sortedGroup);
            StringBuilder builder = new StringBuilder("(");
            for (Long id : sortedGroup) {
                builder.append("" + id + ",");
            }
            builder.setCharAt(builder.length() - 1, ')');
            groupLists[g] = builder.toString();
            ++g;
        }
        Arrays.sort(groupLists);
        StringBuilder builder = new StringBuilder((String)groupLists[0]);
        for (int i = 1; i < numGroups; ++i) {
            builder.append("," + (String)groupLists[i]);
        }
        return builder.toString();
    }

    public static String formattedAttributeGroupList(Collection<Long> attributeGroupIds) {
        ArrayList<Long> list = new ArrayList<Long>();
        list.addAll(attributeGroupIds);
        Collections.sort(list);
        StringBuilder builder = new StringBuilder("(");
        for (Long id : list) {
            builder.append("" + id + ",");
        }
        builder.setCharAt(builder.length() - 1, ')');
        return builder.toString();
    }

    public FeatureList buildFeatureList(IAttributeScorer scorer, boolean enumerateGroups) throws ApplicationException {
        FeatureList features = this.buildFeatureListForSelectedNetworks(enumerateGroups);
        features.addAll(this.buildFeatureListForAttributes(scorer));
        return features;
    }

    public FeatureList buildFeatureListForAttributes(IAttributeScorer scorer) throws ApplicationException {
        IAttributeSelector selector = this.getAttributeSelector();
        ObjectSelector<Feature> bigList = new ObjectSelector<Feature>();
        for (long attributeGroupId : this.attributeGroupIds) {
            ObjectSelector<Feature> list = scorer.scoreAttributes(this.namespace, this.organismId, attributeGroupId);
            list = selector.selectGroupAttributes(list);
            bigList.add(list);
        }
        bigList = selector.selectOverallAttributes(bigList);
        FeatureList features = new FeatureList();
        features.addAll(bigList.getElements());
        return features;
    }

    private IAttributeSelector getAttributeSelector() {
        int leveledLimit = Math.round(1.5f * (float)this.attributesLimit);
        return new TopXOverallSelector(this.attributesLimit, leveledLimit);
    }

    public FeatureList buildFeatureListForSelectedNetworks(boolean enumerateGroups) throws ApplicationException {
        FeatureList features = new FeatureList();
        int fakeGroupId = 1;
        for (Collection<Long> group : this.networkIds) {
            for (long networkId : group) {
                if (enumerateGroups) {
                    features.add(new Feature(Constants.NetworkType.SPARSE_MATRIX, fakeGroupId, networkId));
                    continue;
                }
                features.add(new Feature(Constants.NetworkType.SPARSE_MATRIX, 1L, networkId));
            }
            ++fakeGroupId;
        }
        return features;
    }

    public static FeatureWeightMap convertToFeatureWeightMap(Map<Long, Double> networkWeights) {
        FeatureWeightMap weightMap = new FeatureWeightMap();
        for (Map.Entry<Long, Double> entry : networkWeights.entrySet()) {
            weightMap.put(new Feature(Constants.NetworkType.SPARSE_MATRIX, 0L, entry.getKey()), entry.getValue());
        }
        return weightMap;
    }

    public static Map<Long, Double> convertToWeightMap(FeatureWeightMap featureWeights) throws ApplicationException {
        HashMap<Long, Double> map = new HashMap<Long, Double>();
        for (Feature feature : featureWeights.keySet()) {
            if (feature.getType() != Constants.NetworkType.SPARSE_MATRIX) {
                throw new ApplicationException("can't convert weight map");
            }
            map.put(feature.getId(), (Double)featureWeights.get(feature));
        }
        return map;
    }
}

