/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.integration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.genemania.engine.Constants;
import org.genemania.engine.core.integration.Feature;

public class FeatureWeightMap
extends HashMap<Feature, Double> {
    private static final long serialVersionUID = -1013826142154334182L;

    public double getNetworkWeight(long networkId) {
        return (Double)this.get(new Feature(Constants.NetworkType.SPARSE_MATRIX, 0L, networkId));
    }

    public double getAttributeWeight(long attributeGroupId, long attributeId) {
        return (Double)this.get(new Feature(Constants.NetworkType.ATTRIBUTE_VECTOR, attributeGroupId, attributeId));
    }

    public Map<Long, Collection<Feature>> getGroupedAttributes() {
        HashMap<Long, Collection<Feature>> result = new HashMap<Long, Collection<Feature>>();
        for (Feature feature : this.keySet()) {
            if (feature.getType() != Constants.NetworkType.ATTRIBUTE_VECTOR) continue;
            Collection<Feature> features = result.get(feature.getGroupId());
            if (features == null) {
                features = new ArrayList<Feature>();
                result.put(feature.getGroupId(), features);
            }
            features.add(feature);
        }
        return result;
    }
}

