/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.integration;

import java.io.Serializable;
import org.genemania.engine.Constants;

public class Feature
implements Comparable<Feature>,
Serializable {
    private static final long serialVersionUID = 523872447663612391L;
    public static final long FAKE_SPARSE_NETWORK_GROUP_ID = 1L;
    private final Constants.NetworkType type;
    private final long groupId;
    private final long id;

    public Feature(Constants.NetworkType type, long groupId, long id) {
        this.type = type;
        this.groupId = groupId;
        this.id = id;
    }

    public Constants.NetworkType getType() {
        return this.type;
    }

    public long getGroupId() {
        return this.groupId;
    }

    public long getId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.groupId ^ this.groupId >>> 32);
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Feature other = (Feature)obj;
        if (this.groupId != other.groupId) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        return this.type == other.type;
    }

    @Override
    public int compareTo(Feature that) {
        int cmp = this.getType().compareTo(that.getType());
        if (cmp != 0) {
            return cmp;
        }
        long lcmp = this.getGroupId() - that.getGroupId();
        if (lcmp != 0L) {
            return this.shorten(lcmp);
        }
        lcmp = this.getId() - that.getId();
        return this.shorten(lcmp);
    }

    private int shorten(long a) {
        if (a == 0L) {
            return 0;
        }
        return a < 0L ? -1 : 1;
    }

    public String toString() {
        return this.key(false);
    }

    public String key(boolean ignoreSparseNetworkGroup) {
        long groupId = this.getGroupId();
        if (ignoreSparseNetworkGroup && this.getType() == Constants.NetworkType.SPARSE_MATRIX) {
            groupId = 1L;
        }
        return String.format("%s-%d-%d", this.getType().getCode(), groupId, this.getId());
    }
}

