/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.evaluation.correlation;

import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.VectorEntry;
import org.genemania.engine.core.MatrixUtils;

public class PearsonRow {
    private Vector s;
    private Vector d;
    private double k;
    private double m;
    private double ss;
    private double sd;

    public PearsonRow(Vector s, Vector d, double k, double m) {
        this.s = s;
        this.d = d;
        this.k = k;
        this.m = m;
        this.calculateSS();
        this.calculateSD();
    }

    public Vector getS() {
        return this.s;
    }

    public void add(double k) {
        this.m += k;
    }

    public void multiply(double a) {
        this.s.scale(a);
        this.k *= a;
        this.m *= a;
        this.calculateSS();
        this.calculateSD();
    }

    public void normalize(double mean, double stdev) {
        this.s.scale(1.0 / (stdev + 1.0E-13));
        this.k /= stdev + 1.0E-13;
        this.m = (this.m - mean) / (stdev + 1.0E-13);
        this.calculateSS();
        this.calculateSD();
    }

    public static double dot(PearsonRow r1, PearsonRow r2, double dtd, double dd, int n) {
        double retVal = r1.s.dot(r2.s) + r1.sd * r2.k + r2.sd * r1.k + r1.ss * r2.m + r2.ss * r1.m + r1.k * r2.k * dtd + (r1.k * r2.m + r2.k * r1.m) * dd + r1.m * r2.m * (double)n;
        return retVal;
    }

    public void zero() {
        this.s.zero();
        this.m = 0.0;
        this.k = 0.0;
    }

    public void replaceMissingData(double value) {
        boolean hasNan = false;
        for (VectorEntry e : this.s) {
            if (!Double.isNaN(e.get())) continue;
            double newValue = this.d.size() > 0 ? value - this.k * this.d.get(e.index()) - this.m : value - this.m;
            e.set(newValue);
            hasNan = true;
        }
        if (hasNan) {
            this.calculateSS();
            this.calculateSD();
        }
    }

    public int getNumberOfElements() {
        return this.s.size();
    }

    public double getValueAt(int i) {
        if (this.d.size() > 0) {
            return this.s.get(i) + this.k * this.d.get(i) + this.m;
        }
        return this.s.get(i) + this.m;
    }

    private void calculateSS() {
        this.ss = MatrixUtils.sum(this.s);
    }

    private void calculateSD() {
        if (this.d.size() > 0) {
            this.sd = this.s.dot(this.d);
        }
    }
}

