/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.evaluation.correlation;

import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.VectorEntry;
import no.uib.cipr.matrix.sparse.SparseVector;
import org.genemania.engine.core.MatrixUtils;
import org.genemania.engine.core.evaluation.correlation.AbstractPearson;
import org.genemania.engine.core.evaluation.correlation.PearsonRow;

public class LogScaledPearsonBinaryWithNormalization
extends AbstractPearson {
    protected double dd;
    protected double dtd;

    @Override
    protected void createPearsonRow() {
        int i;
        int numGenes = this.geneData.getGeneExpression().size();
        int numFeatures = this.geneData.getGeneExpression().get(0).size();
        int[] nonZeroCounts = new int[numFeatures];
        SparseVector d = new SparseVector(numFeatures);
        for (i = 0; i < this.rows.length; ++i) {
            Vector v = this.geneData.getGeneExpression().get(i);
            for (VectorEntry e : v) {
                int n = e.index();
                nonZeroCounts[n] = nonZeroCounts[n] + 1;
            }
        }
        for (i = 0; i < numFeatures; ++i) {
            double b = (double)nonZeroCounts[i] / (double)numGenes;
            d.set(i, Math.log(1.0 - b));
        }
        for (i = 0; i < this.rows.length; ++i) {
            Vector v = this.geneData.getGeneExpression().get(i);
            for (VectorEntry e : v) {
                double b = (double)nonZeroCounts[e.index()] / (double)numGenes;
                e.set(-1.0 * Math.log(b) - Math.log(1.0 - b));
            }
            this.rows[i] = new PearsonRow(v, (Vector)d, 1.0, 0.0);
        }
        this.dd = MatrixUtils.sum((Vector)d);
        this.dtd = d.dot((Vector)d);
    }

    @Override
    protected double getDD() {
        return this.dd;
    }

    @Override
    protected double getDTD() {
        return this.dtd;
    }
}

