/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.evaluation.correlation;

import java.util.List;
import no.uib.cipr.matrix.Vector;
import org.genemania.engine.core.evaluation.ProfileData;
import org.genemania.engine.core.evaluation.correlation.Correlation;
import org.genemania.engine.core.evaluation.correlation.MutualInformationData;

public abstract class AbstractMutualInformation
implements Correlation {
    protected int numGenes;
    protected int numFeatures;
    protected int numBins;
    protected List<Vector> geneExpressions;
    private double[] individualEntropies;
    private boolean[] calculated;

    @Override
    public void init(ProfileData data) {
        this.geneExpressions = data.getGeneExpression();
        this.numGenes = this.geneExpressions.size();
        this.numFeatures = this.geneExpressions.get(0).size();
        this.individualEntropies = new double[this.numGenes];
        this.calculated = new boolean[this.numGenes];
        this.init();
    }

    protected abstract void init();

    @Override
    public double computeCorrelations(int i, int j) {
        Vector values_i = this.geneExpressions.get(i);
        Vector values_j = this.geneExpressions.get(j);
        int[] indCounts_i = new int[this.numBins];
        int[] indCounts_j = new int[this.numBins];
        int[] jointCounts = new int[this.numBins * this.numBins];
        for (int k = 0; k < this.numFeatures; ++k) {
            int index;
            int binNumber_i = this.getBinNumber(i, values_i, k);
            int binNumber_j = this.getBinNumber(j, values_j, k);
            if (!this.calculated[i]) {
                int n = binNumber_i;
                indCounts_i[n] = indCounts_i[n] + 1;
            }
            if (!this.calculated[j]) {
                int n = binNumber_j;
                indCounts_j[n] = indCounts_j[n] + 1;
            }
            int n = index = binNumber_i * this.numBins + binNumber_j;
            jointCounts[n] = jointCounts[n] + 1;
        }
        if (!this.calculated[i]) {
            this.individualEntropies[i] = this.computeEntropy(indCounts_i, this.numFeatures);
            this.calculated[i] = true;
        }
        double indEntropy_i = this.individualEntropies[i];
        if (!this.calculated[j]) {
            this.individualEntropies[j] = this.computeEntropy(indCounts_j, this.numFeatures);
            this.calculated[j] = true;
        }
        double indEntropy_j = this.individualEntropies[j];
        double jointEntropy = this.computeEntropy(jointCounts, this.numFeatures);
        return indEntropy_i + indEntropy_j - jointEntropy;
    }

    protected abstract int getBinNumber(int var1, Vector var2, int var3);

    private double computeEntropy(int[] counts, int total) {
        double entropy = 0.0;
        int[] arr$ = counts;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double count = arr$[i$];
            if (!(count > 0.0)) continue;
            double frequency = count / (double)total;
            entropy += -1.0 * frequency * Math.log10(frequency) / Math.log10(2.0);
        }
        return entropy;
    }

    protected int getNumberOfBins(int numGenes, MutualInformationData.SizeType sizeType) {
        switch (sizeType) {
            default: {
                int low = (int)Math.floor(Math.sqrt(numGenes));
                int upper = (int)Math.ceil(Math.log10((double)numGenes + 1.0) / Math.log10(2.0));
                return (low + upper) / 2;
            }
            case LOWER: {
                return (int)Math.floor(Math.sqrt(numGenes));
            }
            case UPPER: 
        }
        return (int)Math.ceil(Math.log10((double)numGenes + 1.0) / Math.log10(2.0));
    }

    protected int getBinNumber(double value, int numBin, double start, double end) {
        return (int)Math.floor((value - start) / ((end - start + 1.0) / (double)numBin));
    }

    @Override
    public double getThresholdValue() {
        return 0.0;
    }
}

