/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.data;

import no.uib.cipr.matrix.DenseMatrix;
import org.genemania.engine.core.data.Data;

public class KtT
extends Data {
    private static final long serialVersionUID = -2709140842827973884L;
    private String goBranch;
    private DenseMatrix data;

    public KtT(String namespace, long organismId, String goBranch) {
        super(namespace, organismId);
        this.goBranch = goBranch;
    }

    @Override
    public KtT copy(String newNamespace) {
        KtT copy = new KtT(newNamespace, this.getOrganismId(), this.getGoBranch());
        DenseMatrix newData = this.data.copy();
        copy.setData(newData);
        return copy;
    }

    public DenseMatrix getData() {
        return this.data;
    }

    public void setData(DenseMatrix data) {
        this.data = data;
    }

    public String getGoBranch() {
        return this.goBranch;
    }

    public void setGoBranch(String goBranch) {
        this.goBranch = goBranch;
    }

    @Override
    public String[] getKey() {
        return new String[]{this.getNamespace(), "" + this.getOrganismId(), this.getGoBranch() + ".KtT"};
    }

    public void removeNetworkAtIndex(int index) {
        DenseMatrix newData = new DenseMatrix(this.data.numRows() - 1, 1);
        int j = 0;
        for (int i = 0; i < this.data.numRows(); ++i) {
            if (i == index) continue;
            newData.set(j, 0, this.data.get(i, 0));
            ++j;
        }
        this.data = newData;
    }
}

