/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.converter.sym;

import org.apache.log4j.Logger;
import org.genemania.engine.config.Config;
import org.genemania.engine.converter.sym.INetworkSymMatrixProvider;
import org.genemania.engine.core.data.NodeIds;
import org.genemania.engine.core.utils.Normalization;
import org.genemania.engine.matricks.SymMatrix;
import org.genemania.exception.ApplicationException;
import org.genemania.mediator.InteractionCursor;
import org.genemania.util.ProgressReporter;

public abstract class CursorNetworkSymMatrixProvider
implements INetworkSymMatrixProvider {
    private static Logger logger = Logger.getLogger(CursorNetworkSymMatrixProvider.class);
    protected InteractionCursor cursor;
    protected NodeIds nodeIds;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SymMatrix convertNetworkToMatrix(ProgressReporter progress) throws ApplicationException {
        progress.setMaximumProgress((int)this.cursor.getTotalInteractions());
        int count = 0;
        int n = this.nodeIds.getNodeIds().length;
        SymMatrix matrix = Config.instance().getMatrixFactory().symSparseMatrix(n);
        try {
            while (this.cursor.next()) {
                progress.setProgress(count);
                int fromNodeIndex = this.nodeIds.getIndexForId(this.cursor.getFromNodeId());
                int toNodeIndex = this.nodeIds.getIndexForId(this.cursor.getToNodeId());
                double weight = this.cursor.getWeight();
                matrix.set(fromNodeIndex, toNodeIndex, weight);
                ++count;
            }
        }
        finally {
            this.cursor.close();
        }
        matrix.setDiag(0.0);
        Normalization.normalizeNetwork(matrix);
        return matrix;
    }
}

