/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.converter;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Vector;

public class Mapping<AliasObject, UniqueObject> {
    private LinkedHashMap<AliasObject, UniqueObject> aliasToUniqueMap = new LinkedHashMap();
    private LinkedHashMap<UniqueObject, Integer> uniqueToIndexMap = new LinkedHashMap();
    private Vector<UniqueObject> indexToUniqueObjectTable = new Vector();
    private HashMap<UniqueObject, AliasObject> preferredAlias = new HashMap();

    public void addAlias(AliasObject alias, UniqueObject uniqueId) {
        if (this.aliasToUniqueMap.containsKey(alias)) {
            UniqueObject currentUniqueId = this.aliasToUniqueMap.get(alias);
            if (!currentUniqueId.equals(uniqueId)) {
                System.out.println(String.format("Consistency error, alias %s with uniqueId %s was already mapped to uniqueId %s, ignoring", alias.toString(), uniqueId, this.toString(), currentUniqueId.toString()));
            }
            return;
        }
        this.addUniqueId(uniqueId);
        this.aliasToUniqueMap.put(alias, uniqueId);
        this.offerPreferredAlias(alias, uniqueId);
    }

    private boolean offerPreferredAlias(AliasObject alias, UniqueObject uniqueId) {
        if (this.preferredAlias.containsKey(uniqueId)) {
            return false;
        }
        this.preferredAlias.put(uniqueId, alias);
        return true;
    }

    public AliasObject getPreferredAliasForUniqueId(UniqueObject uniqueId) {
        return this.preferredAlias.get(uniqueId);
    }

    public AliasObject getPreferredAliasForIndex(int index) {
        UniqueObject uniqueId = this.getUniqueIdForIndex(index);
        if (index == -1) {
            return null;
        }
        return this.getPreferredAliasForUniqueId(uniqueId);
    }

    public void addUniqueId(UniqueObject uniqueId) {
        if (!this.uniqueToIndexMap.containsKey(uniqueId)) {
            int nextIndex = this.size();
            this.uniqueToIndexMap.put(uniqueId, nextIndex);
            this.indexToUniqueObjectTable.add(uniqueId);
        }
    }

    public UniqueObject getUniqueIdForAlias(AliasObject alias) {
        return this.aliasToUniqueMap.get(alias);
    }

    public int getIndexForUniqueId(UniqueObject uniqueId) {
        if (this.uniqueToIndexMap.containsKey(uniqueId)) {
            return this.uniqueToIndexMap.get(uniqueId);
        }
        return -1;
    }

    public UniqueObject getUniqueIdForIndex(int index) {
        if (index >= 0 && index < this.size()) {
            return this.indexToUniqueObjectTable.get(index);
        }
        return null;
    }

    public int getIndexForAlias(AliasObject alias) {
        UniqueObject uniqueId = this.getUniqueIdForAlias(alias);
        if (uniqueId == null) {
            return -1;
        }
        return this.getIndexForUniqueId(uniqueId);
    }

    public int size() {
        return this.indexToUniqueObjectTable.size();
    }

    public Object[] getIndexToUniqueIDTable() {
        Object[] table = null;
        table = this.indexToUniqueObjectTable.toArray();
        return table;
    }
}

