/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.config;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.log4j.Logger;
import org.genemania.engine.config.MatrixFactory;
import org.genemania.exception.ApplicationException;

public class Config {
    private static Logger logger = Logger.getLogger(Config.class);
    private static Config config;
    public static final String DEFAULT_ENGINE_CONFIG_FILE = "org/genemania/engine/Engine.properties";
    static final String MATRIX_FACTORY_CLASS_NAME = "matrixFactoryClassName";
    static final String VERSION = "version";
    static final String IS_REG_ENABLED = "isRegularizationEnabled";
    static final String REG_CONST = "regularizationConstant";
    static final String IS_NETWORK_WEIGHT_NORMALIZATION_ENABLED = "isNetworkWeightNormalizationEnabled";
    static final String IS_COMBINED_NETWORK_NORMALIZATION_ENABLED = "isCombinedNetworkNormalizationEnabled";
    static final String ATTRIBUTE_ENRICHMENT_MAX_SIZE = "attributeEnrichmentMaxSize";
    private MatrixFactory matrixFactory;
    private Configuration configData;

    protected Config() {
    }

    public static synchronized Config instance() {
        if (config == null) {
            try {
                Config.reload();
            }
            catch (ApplicationException e) {
                logger.error((Object)"configuration error", (Throwable)e);
            }
        }
        return config;
    }

    public static synchronized void reload() throws ApplicationException {
        Config.reload(DEFAULT_ENGINE_CONFIG_FILE);
    }

    public static void reload(String configFile) throws ApplicationException {
        logger.info((Object)("loading engine config from " + configFile));
        try {
            Config newConfig = new Config();
            newConfig.configData = new PropertiesConfiguration(configFile);
            config = newConfig;
        }
        catch (ConfigurationException e) {
            throw new ApplicationException("failed to load configuration from " + configFile, (Throwable)e);
        }
    }

    private Object createObject(String className) {
        Object object = null;
        try {
            Class<?> classDef = Class.forName(className);
            object = classDef.newInstance();
        }
        catch (Exception e) {
            logger.error((Object)("failed to create instance of: " + className), (Throwable)e);
        }
        return object;
    }

    public MatrixFactory getMatrixFactory() {
        if (this.matrixFactory == null) {
            String className = this.configData.getString(MATRIX_FACTORY_CLASS_NAME);
            this.matrixFactory = (MatrixFactory)this.createObject(className);
        }
        return this.matrixFactory;
    }

    public String getVersion() {
        return this.configData.getString(VERSION, "UNKNOWN");
    }

    public boolean isRegularizationEnabled() {
        return this.configData.getBoolean(IS_REG_ENABLED, false);
    }

    public double getRegularizationConstant() {
        return this.configData.getDouble(REG_CONST, 1.0);
    }

    public boolean isNetworkWeightNormalizationEnabled() {
        return this.configData.getBoolean(IS_NETWORK_WEIGHT_NORMALIZATION_ENABLED, true);
    }

    public boolean isCombinedNetworkRenormalizationEnabled() {
        return this.configData.getBoolean(IS_COMBINED_NETWORK_NORMALIZATION_ENABLED, false);
    }

    public int getAttributeEnrichmentMaxSize() {
        return this.configData.getInt(ATTRIBUTE_ENRICHMENT_MAX_SIZE, 100);
    }
}

