/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.apps;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.genemania.domain.Organism;
import org.genemania.engine.Constants;
import org.genemania.engine.apps.AbstractEngineApp;
import org.genemania.engine.config.Config;
import org.genemania.engine.core.data.CombinedNetwork;
import org.genemania.engine.core.integration.FeatureWeightMap;
import org.genemania.engine.core.integration.INetworkWeightCalculator;
import org.genemania.engine.core.integration.NetworkWeightCalculatorFactory;
import org.genemania.engine.core.integration.calculators.AbstractNetworkWeightCalculator;
import org.genemania.engine.matricks.SymMatrix;
import org.genemania.exception.ApplicationException;
import org.genemania.exception.DataStoreException;
import org.genemania.util.NullProgressReporter;
import org.genemania.util.ProgressReporter;
import org.kohsuke.args4j.Option;

public class NetworkPrecombiner
extends AbstractEngineApp {
    private static Logger logger = Logger.getLogger(NetworkPrecombiner.class);
    @Option(name="-orgId", usage="optional organism id, otherwise will process all oganisms")
    private static int orgId = -1;
    @Option(name="-combineGroups", usage="optinal, build precombined networks for each network group individually, defaults to false")
    private static boolean combineGroups = false;

    public void processAllOrganisms() throws Exception {
        this.processAllOrganisms(NullProgressReporter.instance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAllOrganisms(ProgressReporter progress) throws Exception {
        for (Organism organism : this.organismMediator.getAllOrganisms()) {
            this.processOrganism(organism, progress);
        }
    }

    public void processOrganism(int organismId, ProgressReporter progress) throws Exception {
        Organism organism = this.organismMediator.getOrganism((long)organismId);
        this.processOrganism(organism, progress);
    }

    public void processOrganism(Organism organism, ProgressReporter progress) throws Exception {
        this.preComputeForNetworkCollections(organism);
    }

    void preComputeForNetworkCollections(Organism organism) throws ApplicationException, DataStoreException {
        logger.info((Object)"precomputing default networks");
        Collection<Collection<Long>> networkIds = NetworkPrecombiner.getDefaultNetworks(organism);
        this.preComputeForAllMethods(organism, networkIds);
        logger.info((Object)"precomputing all networks");
        networkIds = NetworkPrecombiner.getAllNetworks(organism);
        this.preComputeForAllMethods(organism, networkIds);
        if (combineGroups) {
            for (Collection<Long> group : networkIds) {
                logger.info((Object)"precomputing for network group");
                ArrayList<Collection<Long>> holder = new ArrayList<Collection<Long>>();
                holder.add(group);
                this.preComputeForAllMethods(organism, holder);
            }
        }
    }

    void preComputeForAllMethods(Organism organism, Collection<Collection<Long>> networkIds) throws ApplicationException, DataStoreException {
        for (int goBranchNum = 0; goBranchNum < Constants.goBranches.length; ++goBranchNum) {
            Constants.CombiningMethod method = Constants.getMethodForBranch(Constants.goBranches[goBranchNum]);
            logger.info((Object)("using method " + (Object)((Object)method) + " for goBranch " + Constants.goBranches[goBranchNum]));
            this.precomputeForNetworks(organism, method, networkIds);
        }
        this.precomputeForNetworks(organism, Constants.CombiningMethod.AVERAGE, networkIds);
        this.precomputeForNetworks(organism, Constants.CombiningMethod.AVERAGE_CATEGORY, networkIds);
    }

    void precomputeForNetworks(Organism organism, Constants.CombiningMethod method, Collection<Collection<Long>> networkIds) throws ApplicationException {
        logger.info((Object)("using method " + (Object)((Object)method)));
        ArrayList<Long> attributeGroupIds = new ArrayList<Long>();
        INetworkWeightCalculator calculator = NetworkWeightCalculatorFactory.getCalculator("CORE", this.cache, networkIds, attributeGroupIds, organism.getId(), null, Config.instance().getAttributeEnrichmentMaxSize(), method, NullProgressReporter.instance());
        calculator.process();
        FeatureWeightMap weights = calculator.getWeights();
        SymMatrix combinedNetwork = calculator.getCombinedMatrix();
        combinedNetwork.compact();
        double WtW = combinedNetwork.elementMultiplySum(combinedNetwork);
        logger.debug((Object)("WtW: " + WtW));
        String key = calculator.getParameterKey();
        String hash = AbstractNetworkWeightCalculator.hashString(key);
        logger.info((Object)("storing precombined network for organism " + organism.getId() + " with hash " + hash + " for combination key " + key));
        CombinedNetwork combined = new CombinedNetwork("CORE", organism.getId(), hash);
        combined.setFeatureWeightMap(weights);
        combined.setWtW(WtW);
        combined.setData(combinedNetwork);
        this.cache.putCombinedNetwork(combined);
    }

    @Override
    public void init() throws Exception {
        super.init();
    }

    @Override
    public void process() throws Exception {
        if (orgId == -1) {
            this.processAllOrganisms();
        } else {
            this.processOrganism(orgId, NullProgressReporter.instance());
        }
    }

    public static void main(String[] args) throws Exception {
        NetworkPrecombiner combiner = new NetworkPrecombiner();
        if (!combiner.getCommandLineArgs(args)) {
            System.exit(1);
        }
        try {
            combiner.init();
            combiner.process();
            combiner.cleanup();
        }
        catch (Exception e) {
            logger.error((Object)"Fatal exception", (Throwable)e);
            System.exit(1);
        }
    }
}

