/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.actions;

import org.apache.log4j.Logger;
import org.genemania.dto.RemoveNetworkEngineRequestDto;
import org.genemania.dto.RemoveNetworkEngineResponseDto;
import org.genemania.engine.actions.support.UserDataPrecomputer;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.core.data.Network;
import org.genemania.exception.ApplicationException;
import org.genemania.util.NullProgressReporter;

public class RemoveNetworks {
    private static Logger logger = Logger.getLogger(RemoveNetworks.class);
    DataCache cache;
    RemoveNetworkEngineRequestDto request;

    public RemoveNetworks(DataCache cache, RemoveNetworkEngineRequestDto request) {
        this.cache = cache;
        this.request = request;
    }

    public RemoveNetworkEngineResponseDto process() throws ApplicationException {
        if (this.request.getNamespace() == null) {
            throw new ApplicationException("no namepspace specified");
        }
        if (this.request.getOrganismId() != 0L && this.request.getNetworkId() == 0L) {
            return this.removeUserOrganism();
        }
        if (this.request.getOrganismId() == 0L && this.request.getNetworkId() != 0L) {
            throw new ApplicationException("must specify organism to remove individual network");
        }
        if (this.request.getNetworkId() > 0L) {
            throw new ApplicationException("can not remove core network");
        }
        if (this.request.getOrganismId() == 0L && this.request.getNetworkId() == 0L) {
            return this.removeUserNamespace();
        }
        if (this.request.getOrganismId() != 0L && this.request.getNetworkId() < 0L) {
            return this.removeUserNetwork();
        }
        throw new ApplicationException("unexpected input");
    }

    private RemoveNetworkEngineResponseDto removeUserNetwork() throws ApplicationException {
        Network network = new Network(this.request.getNamespace(), this.request.getOrganismId(), this.request.getNetworkId());
        UserDataPrecomputer precomputer = new UserDataPrecomputer(this.request.getNamespace(), (int)this.request.getOrganismId(), this.cache, NullProgressReporter.instance());
        precomputer.removeNetwork((int)this.request.getNetworkId());
        this.cache.removeData(network);
        return new RemoveNetworkEngineResponseDto();
    }

    private RemoveNetworkEngineResponseDto removeUserOrganism() throws ApplicationException {
        this.cache.removeOrganism(this.request.getNamespace(), this.request.getOrganismId());
        return new RemoveNetworkEngineResponseDto();
    }

    private RemoveNetworkEngineResponseDto removeUserNamespace() throws ApplicationException {
        this.cache.removeNamespace(this.request.getNamespace());
        return new RemoveNetworkEngineResponseDto();
    }
}

