/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;

public class HttpRetriever {
    public String getContent(String url, String fromToken, String toToken) {
        String page = this.fetchPage(url);
        String ret = this.scrapContent(page, fromToken, toToken);
        return ret;
    }

    public String post(String url, Hashtable<String, String> params) {
        String ret = "";
        try {
            HttpClient client = new HttpClient();
            PostMethod method = new PostMethod(url);
            Enumeration<String> paramNames = params.keys();
            while (paramNames.hasMoreElements()) {
                String nextParamName = paramNames.nextElement();
                String nextParamValue = params.get(nextParamName);
                method.addParameter(nextParamName, nextParamValue);
            }
            int statusCode = client.executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                System.out.println("HttpRetriever error: " + method.getStatusLine());
            } else {
                byte[] responseBody = method.getResponseBody();
                method.releaseConnection();
                ret = new String(responseBody);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private String fetchPage(String url) {
        String ret = "";
        try {
            HttpClient client = new HttpClient();
            GetMethod method = new GetMethod(url);
            int statusCode = client.executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                System.out.println("HttpRetriever error: " + method.getStatusLine());
            } else {
                byte[] responseBody = method.getResponseBody();
                method.releaseConnection();
                ret = new String(responseBody);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private String scrapContent(String content, String fromToken, String toToken) {
        int toIndex;
        String ret = "";
        int fromIndex = content.indexOf(fromToken);
        if (fromIndex > 0 && (toIndex = content.indexOf(toToken, fromIndex += fromToken.length())) > 0) {
            ret = content.substring(fromIndex, toIndex);
        }
        return ret;
    }

    public static void main(String[] args) {
        StringBuffer result = new StringBuffer();
        HttpRetriever r = new HttpRetriever();
        List<String> titles = HttpRetriever.getTitles();
        for (String title : titles) {
            System.out.println("processing " + title);
            String escTitle = StringUtils.replace((String)title, (String)" ", (String)"%20");
            String url = "http://www.imdb.com/find?q='" + escTitle + "'";
            String from = "<h5>Plot:</h5>";
            String to = "<a class=\"tn15more inline\"";
            String fragment = r.getContent(url, from, to);
            if (StringUtils.isEmpty((String)fragment)) {
                String from1 = "(new Image()).src='/rg/find-title-1/title_popular/images/b.gif?link=";
                String to1 = "/';\">";
                String url1 = "http://www.imdb.com" + r.getContent(url, from1, to1);
                from = "<h5>Plot:</h5>";
                to = "<a class=\"tn15more inline\"";
                fragment = r.getContent(url1, from, to);
            }
            result.append(title + ":" + fragment + "\n");
        }
        System.out.println("done.");
        System.out.println("============================================================");
        System.out.println(result.toString());
        System.out.println("============================================================");
    }

    private static List<String> getTitles() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("Dick Tracy");
        ret.add("Flatliners");
        ret.add("Meet the Fockers");
        ret.add("Men in Black");
        ret.add("Primal Fear");
        return ret;
    }
}

