/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.message;

import com.thoughtworks.xstream.XStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.genemania.dto.InteractionDto;
import org.genemania.dto.NetworkDto;
import org.genemania.dto.NetworkGroupDto;
import org.genemania.dto.NodeDto;
import org.genemania.dto.OntologyCategoryDto;
import org.genemania.message.RelatedGenesRequestMessage;
import org.genemania.message.RelatedGenesResponseMessage;

public class RelatedGenesMessageBase
implements Serializable {
    private static final long serialVersionUID = 1930790196821490296L;
    protected static XStream XS = new XStream();
    private int errorCode = 0;
    private String errorMessage = "";
    private long organismId;
    private long ontologyId;
    private Collection<NetworkDto> networks = new ArrayList<NetworkDto>();
    private Collection<Long> positiveNodes = new ArrayList<Long>();
    private String combiningMethod;
    private Collection<Long> attributeGroups = new ArrayList<Long>();

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public long getOrganismId() {
        return this.organismId;
    }

    public void setOrganismId(long organismId) {
        this.organismId = organismId;
    }

    public long getOntologyId() {
        return this.ontologyId;
    }

    public void setOntologyId(long ontolgyId) {
        this.ontologyId = ontolgyId;
    }

    public Collection<Long> getPositiveNodes() {
        return this.positiveNodes;
    }

    public void setPositiveNodes(Collection<Long> positiveNodes) {
        this.positiveNodes = positiveNodes;
    }

    public String getCombiningMethod() {
        return this.combiningMethod;
    }

    public void setCombiningMethod(String combiningMethod) {
        this.combiningMethod = combiningMethod;
    }

    public Collection<NetworkDto> getNetworks() {
        return this.networks;
    }

    public void setNetworks(Collection<NetworkDto> networks) {
        this.networks = networks;
    }

    public Collection<Long> getAttributeGroups() {
        return this.attributeGroups;
    }

    public void setAttributeGroups(Collection<Long> attributeGroups) {
        this.attributeGroups = attributeGroups;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        if (this.errorCode > 0) {
            ret.append("errorCode=" + this.errorCode);
        }
        if (StringUtils.isNotEmpty((String)this.errorMessage)) {
            ret.append("errorMessage=" + this.errorMessage);
        }
        if (this.organismId > 0L) {
            ret.append("organimsId=" + this.organismId);
        }
        ret.append(", combiningMethod=" + this.combiningMethod);
        if (this.networks != null) {
            ret.append(", networks=" + this.networks.size());
        } else {
            ret.append(", networks=null");
        }
        if (this.positiveNodes != null) {
            ret.append(", positiveNodes=" + this.positiveNodes.size());
        } else {
            ret.append(", positiveNodes=null");
        }
        if (this.attributeGroups != null) {
            ret.append(", attributeGroups=" + this.attributeGroups.size());
        } else {
            ret.append(", attributeGroups=null");
        }
        return ret.toString();
    }

    public String toXml() {
        return XS.toXML((Object)this);
    }

    static {
        XS.alias("RelGenReq", RelatedGenesRequestMessage.class);
        XS.aliasField("oid", RelatedGenesRequestMessage.class, "organismId");
        XS.aliasField("networks", RelatedGenesRequestMessage.class, "networks");
        XS.aliasField("nodes", RelatedGenesRequestMessage.class, "positiveNodes");
        XS.aliasField("method", RelatedGenesRequestMessage.class, "combiningMethod");
        XS.alias("network", NetworkDto.class);
        XS.alias("RelGenRes", RelatedGenesResponseMessage.class);
        XS.alias("group", NetworkGroupDto.class);
        XS.alias("network", NetworkDto.class);
        XS.alias("interaction", InteractionDto.class);
        XS.alias("node", NodeDto.class);
        XS.alias("category", OntologyCategoryDto.class);
        XS.aliasField("ontid", RelatedGenesRequestMessage.class, "ontologyId");
        XS.aliasField("attributeGroups", RelatedGenesRequestMessage.class, "attributeGroups");
    }
}

