/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.mediator.lucene.exporter;

import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.genemania.configobj.ConfigObj;
import org.genemania.configobj.Section;
import org.genemania.mediator.lucene.exporter.ExportProfile;

public class CustomExportProfile
implements ExportProfile {
    Set<String> excludedNetworkNames = new HashSet<String>();
    Pattern excludeNetworkPattern;

    public CustomExportProfile(String configFileName) throws IOException {
        ConfigObj config = new ConfigObj(new FileReader(configFileName));
        Section section = config.getSection("Networks");
        this.excludedNetworkNames.addAll(section.getEntries("excludeNames"));
        String excludeNetworkPatternString = section.getEntry("excludePattern");
        if (excludeNetworkPatternString != null) {
            this.excludeNetworkPattern = Pattern.compile(excludeNetworkPatternString);
        }
    }

    @Override
    public boolean includesNetwork(String[] networkData) {
        String name = networkData[1];
        if (this.excludedNetworkNames.contains(name)) {
            return false;
        }
        return this.excludeNetworkPattern == null || !this.excludeNetworkPattern.matcher(name).matches();
    }
}

