/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.data.normalizer;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Set;
import org.genemania.data.normalizer.BaseNormalizer;
import org.genemania.data.normalizer.GeneCompletionProvider2;

public class WeightedNetworkNormalizer
extends BaseNormalizer {
    int fromColumn;
    int toColumn;
    private int weightColumn;

    @Override
    protected void handleBeforeNormalize(BaseNormalizer.ParsingContext context) throws IOException {
        List<Integer> idColumns = context.idColumns;
        if (idColumns.size() < 2) {
            throw new IOException();
        }
        this.fromColumn = idColumns.get(0);
        this.toColumn = idColumns.get(1);
        for (int i = 0; i < 3; ++i) {
            if (i == this.fromColumn || i == this.toColumn) continue;
            this.weightColumn = i;
            break;
        }
    }

    @Override
    protected void handleLine(BaseNormalizer.ParsingContext context, String line, GeneCompletionProvider2 genes, PrintWriter writer) {
        String[] parts = line.split(context.delimiter);
        if (parts.length != this.getColumnCount()) {
            return;
        }
        String fromSymbol = parts[this.fromColumn];
        String toSymbol = parts[this.toColumn];
        Double weight = null;
        if (this.isWeighted() && (weight = this.parseWeight(parts[this.weightColumn])) == null) {
            ++context.droppedInteractions;
            return;
        }
        Long fromId = genes.getNodeId(fromSymbol);
        Long toId = genes.getNodeId(toSymbol);
        this.validateSymbol(fromId, fromSymbol, context.invalidSymbols);
        this.validateSymbol(toId, toSymbol, context.invalidSymbols);
        if (fromId == null || toId == null || fromId == toId) {
            ++context.droppedInteractions;
            return;
        }
        writer.print(fromId);
        writer.print("\t");
        writer.print(toId);
        writer.print("\t");
        if (this.isWeighted()) {
            writer.print(weight);
        }
        writer.print("\n");
        ++context.totalInteractions;
    }

    protected Double parseWeight(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected int getColumnCount() {
        return 3;
    }

    protected void validateSymbol(Long id, String symbol, Set<String> invalidSymbols) {
        if (id == null) {
            invalidSymbols.add(symbol);
        }
    }

    protected boolean isWeighted() {
        return true;
    }
}

