/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.data.normalizer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.genemania.data.normalizer.DataImportSettings;
import org.genemania.data.normalizer.GeneCompletionProvider2;
import org.genemania.data.normalizer.INormalizer;
import org.genemania.data.normalizer.NormalizationResult;
import org.genemania.data.normalizer.Strings;
import org.genemania.util.ProgressReporter;

public abstract class BaseNormalizer
implements INormalizer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NormalizationResult normalize(DataImportSettings classification, GeneCompletionProvider2 genes, Reader input, Writer output, ProgressReporter progress) throws IOException {
        ParsingContext context = new ParsingContext(classification);
        this.handleBeforeNormalize(context);
        PrintWriter writer = new PrintWriter(output);
        try {
            BufferedReader reader = new BufferedReader(input);
            try {
                String line = reader.readLine();
                while (true) {
                    if (line != null) {
                        try {
                            if (progress.isCanceled()) {
                                NormalizationResult normalizationResult = null;
                                return normalizationResult;
                            }
                            progress.setDescription(String.format(Strings.installTextNetwork_description, context.totalInteractions, context.droppedInteractions));
                            this.handleLine(context, line, genes, writer);
                            continue;
                        }
                        finally {
                            line = reader.readLine();
                            continue;
                        }
                    }
                    break;
                }
            }
            finally {
                reader.close();
            }
        }
        finally {
            writer.close();
        }
        NormalizationResult result = new NormalizationResult();
        result.setDroppedEntries(context.droppedInteractions);
        result.setTotalEntries(context.totalInteractions);
        result.setInvalidSymbols(context.invalidSymbols);
        return result;
    }

    protected void handleBeforeNormalize(ParsingContext context) throws IOException {
    }

    protected abstract void handleLine(ParsingContext var1, String var2, GeneCompletionProvider2 var3, PrintWriter var4);

    protected class ParsingContext {
        public String delimiter;
        public int droppedInteractions;
        public int totalInteractions;
        public Set<String> invalidSymbols;
        public List<Integer> idColumns;

        public ParsingContext(DataImportSettings settings) {
            this.delimiter = settings.getDelimiter();
            this.invalidSymbols = new HashSet<String>();
            this.idColumns = settings.getIdColumns();
        }
    }
}

