/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.data.classification.lucene;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.genemania.data.classification.IGeneClassificationHandler;
import org.genemania.data.classification.IGeneClassifier;
import org.genemania.exception.ApplicationException;
import org.genemania.mediator.lucene.AbstractCollector;

public class LuceneGeneClassifier
implements IGeneClassifier {
    private Searcher searcher;
    private Analyzer analyzer;

    public LuceneGeneClassifier(Searcher searcher, Analyzer analyzer) {
        this.searcher = searcher;
        this.analyzer = analyzer;
    }

    @Override
    public void classify(final String symbol, final IGeneClassificationHandler handler) throws ApplicationException {
        try {
            TokenStream tokens = this.analyze(symbol);
            PhraseQuery query = new PhraseQuery();
            tokens.reset();
            while (tokens.incrementToken()) {
                TermAttribute term = (TermAttribute)tokens.getAttribute(TermAttribute.class);
                query.add(new Term("gene", term.term()));
            }
            tokens.end();
            tokens.close();
            this.searcher.search((Query)query, (Collector)new AbstractCollector(){

                @Override
                public void handleHit(int doc) {
                    try {
                        Document document = LuceneGeneClassifier.this.searcher.doc(doc);
                        long organismId = Long.parseLong(document.get("gene_organism_id"));
                        handler.handleClassification(symbol, organismId);
                    }
                    catch (IOException e) {
                        LuceneGeneClassifier.this.log(e);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new ApplicationException(e);
        }
    }

    void log(Throwable t) {
        Logger logger = Logger.getLogger(LuceneGeneClassifier.class);
        logger.error((Object)t.getMessage(), t);
    }

    TokenStream analyze(String text) throws IOException {
        return this.analyzer.reusableTokenStream("gene", (Reader)new StringReader(text));
    }
}

