/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.configobj;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Section {
    private List<Section> children;
    private int level;
    private String name;
    private ArrayList<Map.Entry<String, String>> entries;

    public Section(int level, String name) {
        this.level = level;
        this.name = name;
        this.children = new ArrayList<Section>();
        this.entries = new ArrayList();
    }

    public List<Section> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public Section getSection(String name) {
        for (Section section : this.children) {
            if (!section.name.equals(name)) continue;
            return section;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void addSection(Section section) {
        this.children.add(section);
    }

    public void addEntry(String key, String value) {
        this.entries.add(new GenericEntry<String, String>(key, value));
    }

    public int getLevel() {
        return this.level;
    }

    public List<? extends Map.Entry<String, String>> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public String toString() {
        return String.format("(%s, %d)", this.name, this.level);
    }

    public String getEntry(String key) {
        for (Map.Entry<String, String> entry : this.entries) {
            if (!key.equals(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public List<String> getEntries(String key) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.entries) {
            if (!key.equals(entry.getKey())) continue;
            result.add(entry.getValue());
        }
        return result;
    }

    static class GenericEntry<T, U>
    implements Map.Entry<T, U> {
        private T key;
        private U value;

        public GenericEntry(T key, U value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public T getKey() {
            return this.key;
        }

        @Override
        public U getValue() {
            return this.value;
        }

        @Override
        public U setValue(U value) {
            U old = this.value;
            this.value = value;
            return old;
        }

        public String toString() {
            return String.format("%s=%s", this.key, this.value);
        }
    }
}

