/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.configobj;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.genemania.configobj.Section;

public class ConfigObj
extends Section {
    static final Pattern SECTION_PATTERN = Pattern.compile("\\s*(\\[+)([^\\]]+)(\\]+).*");

    public ConfigObj(Reader input) throws IOException {
        super(0, "");
        LinkedList<Section> sections = new LinkedList<Section>();
        BufferedReader reader = new BufferedReader(input);
        String line = ConfigObj.stripComments(reader.readLine());
        sections.add(this);
        while (line != null) {
            Section current = (Section)sections.peek();
            Section section = ConfigObj.parseSection(line);
            if (section == null) {
                String key;
                String[] parts = line.split("=", 2);
                if (parts.length == 2) {
                    key = parts[0].trim();
                    if (key.length() > 0) {
                        current.addEntry(key, parts[1].trim());
                    }
                } else if (parts.length == 1 && (key = parts[0].trim()).length() > 0) {
                    current.addEntry(key, "");
                }
            } else if (current.getLevel() < section.getLevel()) {
                sections.addFirst(section);
                current.addSection(section);
            } else if (current.getLevel() == section.getLevel()) {
                sections.removeFirst();
                ((Section)sections.peek()).addSection(section);
                sections.addFirst(section);
            } else {
                while (current.getLevel() > section.getLevel()) {
                    current = (Section)sections.removeFirst();
                }
                ((Section)sections.peek()).addSection(section);
                sections.addFirst(section);
            }
            line = ConfigObj.stripComments(reader.readLine());
        }
    }

    private static String stripComments(String text) {
        if (text == null) {
            return null;
        }
        int start = text.indexOf(35);
        if (start == 0) {
            return "";
        }
        if (start > 0) {
            return text.substring(0, start - 1);
        }
        return text;
    }

    private static Section parseSection(String line) {
        int level;
        Matcher matcher = SECTION_PATTERN.matcher(line);
        if (matcher.matches() && (level = matcher.group(1).length()) == matcher.group(3).length()) {
            return new Section(level, matcher.group(2));
        }
        return null;
    }
}

