/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.completion.lucene;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.genemania.completion.lucene.LuceneCompletionProvider;
import org.genemania.domain.Gene;
import org.genemania.mediator.lucene.AbstractCollector;
import org.genemania.mediator.lucene.LuceneGeneMediator;

@Deprecated
public class GeneCompletionProvider
extends LuceneCompletionProvider {
    private GeneCompletionProvider() {
        this(null, null);
    }

    public GeneCompletionProvider(IndexReader reader, Analyzer analyzer) {
        super(reader, "gene", analyzer);
    }

    public Set<String> getSynonyms(String symbol) {
        try {
            Query query = this.parser.parse(String.format("\"%s\"", symbol));
            final Long[] node = new Long[]{-1L};
            this.searcher.search(query, (Collector)new AbstractCollector(){

                @Override
                public void handleHit(int id) {
                    try {
                        Document document = GeneCompletionProvider.this.searcher.doc(id);
                        node[0] = Long.parseLong(document.get("node"));
                    }
                    catch (IOException e) {
                        GeneCompletionProvider.this.log(e);
                    }
                }
            });
            if (node[0] == -1L) {
                return Collections.emptySet();
            }
            return this.getSynonyms(node[0]);
        }
        catch (ParseException e) {
            this.log(e);
        }
        catch (IOException e) {
            this.log(e);
        }
        return Collections.emptySet();
    }

    public Set<String> getSynonyms(Long nodeId) {
        try {
            Query query = this.parser.parse(String.format("%s:%d", "node", nodeId));
            final HashSet<String> synonyms = new HashSet<String>();
            this.searcher.search(query, (Collector)new AbstractCollector(){

                @Override
                public void handleHit(int id) {
                    try {
                        Document document = GeneCompletionProvider.this.searcher.doc(id);
                        synonyms.add(document.get("gene"));
                    }
                    catch (IOException e) {
                        GeneCompletionProvider.this.log(e);
                    }
                }
            });
            return synonyms;
        }
        catch (ParseException e) {
            this.log(e);
        }
        catch (IOException e) {
            this.log(e);
        }
        return Collections.emptySet();
    }

    public Long getNodeId(String symbol) {
        try {
            TokenStream tokens = this.analyze(symbol);
            PhraseQuery query = new PhraseQuery();
            tokens.reset();
            while (tokens.incrementToken()) {
                TermAttribute term = (TermAttribute)tokens.getAttribute(TermAttribute.class);
                query.add(new Term("gene", term.term()));
            }
            tokens.end();
            tokens.close();
            final HashSet nodes = new HashSet();
            this.searcher.search((Query)query, (Collector)new AbstractCollector(){

                @Override
                public void handleHit(int id) {
                    try {
                        Document document = GeneCompletionProvider.this.searcher.doc(id);
                        nodes.add(Long.parseLong(document.get("node")));
                    }
                    catch (IOException e) {
                        GeneCompletionProvider.this.log(e);
                    }
                }
            });
            if (nodes.size() > 0) {
                return (Long)nodes.iterator().next();
            }
        }
        catch (IOException e) {
            this.log(e);
        }
        return null;
    }

    public Gene getGene(String symbol) {
        Analyzer analyzer = this.parser.getAnalyzer();
        LuceneGeneMediator mediator = new LuceneGeneMediator((Searcher)this.searcher, analyzer);
        return mediator.getGeneForSymbol(null, symbol);
    }
}

