/*
 * Decompiled with CFR 0.152.
 */
package savant.view.variation.swing;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import savant.api.util.DialogUtils;
import savant.util.MiscUtils;
import savant.view.tracks.VariantTrack;
import savant.view.variation.VariationController;

public class CaseControlDialog
extends JDialog {
    VariationController controller;
    JPanel checksPanel;

    CaseControlDialog(VariationController vc) {
        super(DialogUtils.getMainWindow(), Dialog.ModalityType.APPLICATION_MODAL);
        this.controller = vc;
        this.setTitle("Select Controls");
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.checksPanel = new JPanel();
        this.checksPanel.setLayout(new GridBagLayout());
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        for (VariantTrack t : this.controller.getTracks()) {
            gbc.insets = new Insets(0, 0, 0, 0);
            JCheckBox cb1 = new JCheckBox(t.getName());
            boolean trackSelected = this.controller.isAControl(t.getName());
            cb1.setSelected(trackSelected);
            this.checksPanel.add((Component)cb1, gbc);
            ArrayList<JCheckBox> dependents = new ArrayList<JCheckBox>();
            gbc.insets = new Insets(0, 40, 0, 0);
            for (String p : t.getParticipantNames()) {
                JCheckBox cb2 = new JCheckBox(p);
                cb2.setSelected(trackSelected || this.controller.isAControl(p));
                cb2.addActionListener(new ParticipantCheckListener(cb1));
                this.checksPanel.add((Component)cb2, gbc);
                dependents.add(cb2);
            }
            cb1.addActionListener(new TrackCheckListener(dependents));
        }
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CaseControlDialog.this.updateControls();
                CaseControlDialog.this.setVisible(false);
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CaseControlDialog.this.setVisible(false);
            }
        });
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.add((Component)new JScrollPane(this.checksPanel), gbc);
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        this.add((Component)okButton, gbc);
        gbc.weightx = 0.0;
        this.add((Component)cancelButton, gbc);
        this.pack();
        this.getRootPane().setDefaultButton(okButton);
        MiscUtils.registerCancelButton(cancelButton);
        this.setLocationRelativeTo(this.getParent());
    }

    void updateControls() {
        HashSet<String> newControls = new HashSet<String>();
        for (Component c : this.checksPanel.getComponents()) {
            if (!((JCheckBox)c).isSelected()) continue;
            newControls.add(((JCheckBox)c).getText());
        }
        this.controller.setControls(newControls);
    }

    static class ParticipantCheckListener
    implements ActionListener {
        JCheckBox trackCheck;

        ParticipantCheckListener(JCheckBox cb) {
            this.trackCheck = cb;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.trackCheck.setSelected(false);
        }
    }

    static class TrackCheckListener
    implements ActionListener {
        List<JCheckBox> dependents;

        TrackCheckListener(List<JCheckBox> deps) {
            this.dependents = deps;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JCheckBox sender = (JCheckBox)ae.getSource();
            for (JCheckBox dep : this.dependents) {
                dep.setSelected(sender.isSelected());
            }
        }
    }
}

