/*
 * Decompiled with CFR 0.152.
 */
package savant.view.variation.swing;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import savant.api.data.Record;
import savant.api.data.VariantRecord;
import savant.api.data.VariantType;
import savant.settings.ColourSettings;
import savant.util.ColourAccumulator;
import savant.util.ColourKey;
import savant.util.ColourScheme;
import savant.util.MiscUtils;
import savant.util.Pileup;
import savant.view.variation.VariationController;
import savant.view.variation.swing.VariantPopper;
import savant.view.variation.swing.VariationPlot;

public class AlleleFrequencyPlot
extends VariationPlot {
    private static final int NUM_AXIS_STEPS = 10;

    AlleleFrequencyPlot(VariationController vc) {
        super(vc);
        VariantPopper popper = new VariantPopper(this);
        this.addMouseListener(popper);
        this.addMouseMotionListener(popper);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int h = this.getHeight();
        int w = this.getWidth();
        GradientPaint gp0 = new GradientPaint(0.0f, 0.0f, ColourSettings.getColor(ColourKey.GRAPH_PANE_BACKGROUND_TOP), 0.0f, h, ColourSettings.getColor(ColourKey.GRAPH_PANE_BACKGROUND_BOTTOM));
        g2.setPaint(gp0);
        g2.fillRect(0, 0, w, h);
        int numControls = 0;
        String[] participants = this.controller.getParticipants();
        int numCases = participants.length * 2;
        for (String p : participants) {
            if (!this.controller.isAControl(p)) continue;
            numControls += 2;
            numCases -= 2;
        }
        List<VariantRecord> data = this.controller.getData();
        if (data != null && !data.isEmpty()) {
            this.unitHeight = (double)h / (double)data.size();
            ArrayList<Pileup> controlPileups = new ArrayList<Pileup>(data.size());
            ArrayList<Pileup> casePileups = new ArrayList<Pileup>(data.size());
            for (int i = 0; i < data.size(); ++i) {
                VariantRecord varRec = data.get(i);
                Pileup controlPile = new Pileup(varRec.getPosition());
                Pileup casePile = new Pileup(varRec.getPosition());
                controlPileups.add(controlPile);
                casePileups.add(casePile);
                for (int j = 0; j < varRec.getParticipantCount(); ++j) {
                    VariantType[] jVariants = varRec.getVariantsForParticipant(j);
                    if (jVariants == null) continue;
                    Pileup pile = casePile;
                    if (numControls > 0 && this.controller.isAControl(participants[j])) {
                        pile = controlPile;
                    }
                    if (jVariants.length == 1) {
                        pile.pileOn(jVariants[0], 1.0, null);
                        pile.pileOn(jVariants[0], 1.0, null);
                        continue;
                    }
                    pile.pileOn(jVariants[0], 1.0, null);
                    pile.pileOn(jVariants[1], 1.0, null);
                }
            }
            this.labelHorizontalAxis(g2, numControls > 0, false);
            ColourScheme scheme = new ColourScheme(ColourKey.A, ColourKey.C, ColourKey.G, ColourKey.T, ColourKey.INSERTED_BASE, ColourKey.DELETED_BASE);
            ColourAccumulator accumulator = new ColourAccumulator(scheme);
            double x0 = numControls > 0 ? (double)this.getWidth() * 0.5 : 0.0;
            double y = 0.0;
            for (int i = 0; i < casePileups.size(); ++i) {
                Rectangle2D.Double rect;
                double barWidth;
                VariantType snpNuc;
                Pileup p = (Pileup)casePileups.get(i);
                this.unitWidth = (double)w / (double)numCases;
                if (numControls > 0) {
                    this.unitWidth *= 0.5;
                }
                double x = x0;
                while ((snpNuc = p.getLargestVariantType(VariantType.NONE)) != null) {
                    barWidth = (double)p.getCoverage(snpNuc, null) * this.unitWidth;
                    rect = new Rectangle2D.Double(x, y, barWidth, this.unitHeight);
                    accumulator.addShape(scheme.getVariantColor(snpNuc), (Shape)rect);
                    p.clearVariantType(snpNuc);
                    x += barWidth;
                }
                if (numControls > 0) {
                    p = (Pileup)controlPileups.get(i);
                    this.unitWidth = (double)w * 0.5 / (double)numControls;
                    x = x0;
                    while ((snpNuc = p.getLargestVariantType(VariantType.NONE)) != null) {
                        barWidth = (double)p.getCoverage(snpNuc, null) * this.unitWidth;
                        rect = new Rectangle2D.Double(x - barWidth, y, barWidth, this.unitHeight);
                        accumulator.addShape(scheme.getVariantColor(snpNuc), (Shape)rect);
                        p.clearVariantType(snpNuc);
                        x += barWidth;
                    }
                }
                y += this.unitHeight;
            }
            accumulator.fill(g2);
            this.labelHorizontalAxis(g2, numControls > 0, true);
            this.labelVerticalAxis(g2);
            if (numControls > 0) {
                Color gridColor = ColourSettings.getColor(ColourKey.AXIS_GRID);
                g2.setColor(gridColor);
                g2.draw(new Line2D.Double((double)w * 0.5, 0.0, (double)w * 0.5, h));
                g2.setColor(new Color(gridColor.getRed(), gridColor.getGreen(), gridColor.getBlue(), 128));
                g2.setFont(g2.getFont().deriveFont(1, 24.0f));
                MiscUtils.drawMessage(g2, "Control", new Rectangle(0, 0, w / 2, h));
                MiscUtils.drawMessage(g2, "Case", new Rectangle(w / 2, 0, w / 2, h));
            }
            g2.setClip(null);
        }
    }

    private void labelHorizontalAxis(Graphics2D g2, boolean hasControls, boolean justLabels) {
        double step;
        int h = this.getHeight();
        int w = this.getWidth();
        Area clipArea = new Area(new Rectangle(0, 0, w, h));
        g2.setColor(ColourSettings.getColor(ColourKey.AXIS_GRID));
        g2.setFont(g2.getFont().deriveFont(0, 9.0f));
        FontMetrics fm = g2.getFontMetrics();
        double verticalAxis = 0.0;
        int numSteps = 10;
        if (hasControls) {
            verticalAxis = (double)this.getWidth() * 0.5;
            numSteps /= 2;
        }
        double x = step = (double)w / 10.0;
        for (int i = 1; i < numSteps; ++i) {
            String s = String.format("%.1f", (double)i / (double)numSteps);
            Rectangle2D labelRect = fm.getStringBounds(s, g2);
            labelRect = new Rectangle2D.Double(verticalAxis + x - labelRect.getWidth() * 0.5 - 1.0, 1.0, labelRect.getWidth() + 2.0, labelRect.getHeight() + 2.0);
            MiscUtils.drawMessage(g2, s, labelRect);
            clipArea.subtract(new Area(labelRect));
            if (hasControls) {
                labelRect = new Rectangle2D.Double(verticalAxis - x - labelRect.getWidth() * 0.5, 1.0, labelRect.getWidth(), labelRect.getHeight());
                MiscUtils.drawMessage(g2, s, labelRect);
                clipArea.subtract(new Area(labelRect));
            }
            g2.setClip(clipArea);
            if (!justLabels) {
                g2.draw(new Line2D.Double(verticalAxis + x, 0.0, verticalAxis + x, h));
                if (hasControls) {
                    g2.draw(new Line2D.Double(verticalAxis - x, 0.0, verticalAxis - x, h));
                }
            }
            x += step;
        }
        g2.setClip(null);
    }

    @Override
    public Record pointToRecord(Point pt) {
        return this.pointToVariantRecord(pt);
    }
}

