/*
 * Decompiled with CFR 0.152.
 */
package savant.view.variation;

import savant.api.data.Record;
import savant.api.data.VariantRecord;
import savant.api.data.VariantType;

public class ParticipantRecord
implements Record {
    VariantRecord variantRecord;
    int index;
    String participantName;

    public ParticipantRecord(VariantRecord varRec, int i, String name) {
        this.variantRecord = varRec;
        this.index = i;
        this.participantName = name;
    }

    @Override
    public String getReference() {
        return this.variantRecord.getReference();
    }

    public int compareTo(Object t) {
        return this.variantRecord.compareTo(t);
    }

    public VariantRecord getVariantRecord() {
        return this.variantRecord;
    }

    public String getName() {
        return this.participantName;
    }

    public VariantType[] getVariants() {
        return this.variantRecord.getVariantsForParticipant(this.index);
    }

    public String[] getAlleles() {
        String allele0;
        String[] altAlleles = this.variantRecord.getAltAlleles();
        int[] alleles = this.variantRecord.getAllelesForParticipant(this.index);
        String string = allele0 = alleles[0] > 0 ? altAlleles[alleles[0] - 1] : this.variantRecord.getRefBases();
        if (alleles.length == 1) {
            return new String[]{allele0};
        }
        return new String[]{allele0, alleles[1] > 0 ? altAlleles[alleles[1] - 1] : this.variantRecord.getRefBases()};
    }
}

