/*
 * Decompiled with CFR 0.152.
 */
package savant.view.variation;

import java.util.ArrayList;
import java.util.List;
import savant.api.data.VariantRecord;
import savant.api.data.VariantType;
import savant.util.AggregateRecord;

public class PaddedVariantRecord
implements VariantRecord,
AggregateRecord<VariantRecord> {
    private final VariantRecord original;
    private final int padding;

    PaddedVariantRecord(VariantRecord rec, int pad) {
        this.original = rec;
        this.padding = pad;
    }

    public String toString() {
        return this.getVariantType().toString() + "@" + this.getPosition();
    }

    @Override
    public VariantType getVariantType() {
        return this.original.getVariantType();
    }

    @Override
    public String getRefBases() {
        return this.original.getRefBases();
    }

    @Override
    public String[] getAltAlleles() {
        return this.original.getAltAlleles();
    }

    @Override
    public int getParticipantCount() {
        return this.padding + this.original.getParticipantCount();
    }

    @Override
    public VariantType[] getVariantsForParticipant(int index) {
        if (index >= this.padding && index < this.getParticipantCount()) {
            return this.original.getVariantsForParticipant(index - this.padding);
        }
        return new VariantType[]{VariantType.NONE};
    }

    @Override
    public int[] getAllelesForParticipant(int index) {
        if (index >= this.padding && index < this.getParticipantCount()) {
            return this.original.getAllelesForParticipant(index - this.padding);
        }
        return new int[]{0};
    }

    @Override
    public int getPosition() {
        return this.original.getPosition();
    }

    @Override
    public String getName() {
        return this.original.getName();
    }

    @Override
    public String getReference() {
        return this.original.getReference();
    }

    @Override
    public boolean isPhased() {
        return this.original.isPhased();
    }

    public int compareTo(Object t) {
        return this.original.compareTo(t);
    }

    public boolean equals(Object t) {
        return this.original.equals(t);
    }

    public int hashCode() {
        return this.original.hashCode();
    }

    @Override
    public List<VariantRecord> getConstituents() {
        ArrayList<VariantRecord> result = new ArrayList<VariantRecord>();
        if (this.original instanceof AggregateRecord) {
            result.addAll(((AggregateRecord)((Object)this.original)).getConstituents());
        } else {
            result.add(this.original);
        }
        return result;
    }
}

