/*
 * Decompiled with CFR 0.152.
 */
package savant.view.variation;

import java.util.List;
import javax.swing.SwingWorker;
import savant.api.data.VariantRecord;
import savant.api.data.VariantType;
import savant.view.variation.VariationController;

public class LDCalculator
extends SwingWorker {
    private final VariationController controller;
    protected final float[][] dPrimes;
    protected final float[][] rSquareds;

    public LDCalculator(VariationController vc, boolean phased) throws OutOfMemoryError {
        this.controller = vc;
        int n = vc.getData().size();
        this.dPrimes = phased ? new float[n][n] : (float[][])null;
        this.rSquareds = new float[n][n];
    }

    protected Object doInBackground() throws Exception {
        if (this.dPrimes != null) {
            this.calculatePhased();
        } else {
            this.calculateUnphased();
        }
        return null;
    }

    public void calculatePhased() {
        List<VariantRecord> data = this.controller.getData();
        int participantCount = this.controller.getParticipantCount();
        for (int i = 0; i < data.size(); ++i) {
            VariantRecord recI = data.get(i);
            VariantType varI = recI.getVariantType();
            int n1 = 0;
            double count = (double)participantCount * 2.0;
            for (int k = 0; k < participantCount; ++k) {
                n1 += this.countMatches(recI.getVariantsForParticipant(k), varI);
            }
            double p1 = (double)n1 / count;
            double p2 = 1.0 - p1;
            for (int j = i + 1; j < data.size(); ++j) {
                if (p1 > 0.0 && p1 < 1.0) {
                    VariantRecord recJ = data.get(j);
                    VariantType varJ = recJ.getVariantType();
                    n1 = 0;
                    int n11 = 0;
                    for (int k = 0; k < participantCount; ++k) {
                        VariantType[] varJK = recJ.getVariantsForParticipant(k);
                        VariantType[] varIK = recI.getVariantsForParticipant(k);
                        if (varJK == null || varIK == null) continue;
                        if (varJK.length == 1) {
                            if (varJK[0] != varJ) continue;
                            n1 += 2;
                            n11 += this.countMatches(varIK, varI);
                            continue;
                        }
                        if (varJK[0] == varJ) {
                            ++n1;
                            if (varIK[0] != varI) continue;
                            ++n11;
                            continue;
                        }
                        if (varJK[1] != varJ) continue;
                        ++n1;
                        if ((varIK.length != 1 || varIK[0] != varI) && (varIK.length != 2 || varIK[1] != varI)) continue;
                        ++n11;
                    }
                    double q1 = (double)n1 / count;
                    double q2 = 1.0 - q1;
                    if (q1 > 0.0 && q1 < 1.0) {
                        double x11 = (double)n11 / count;
                        double d = x11 - p1 * q1;
                        double dMax = d < 0.0 ? -Math.min(p1 * q1, p2 * q2) : Math.min(p1 * q2, p2 * q1);
                        this.dPrimes[i][j] = (float)(d / dMax);
                        this.rSquareds[i][j] = (float)(d * d / (p1 * p2 * q1 * q2));
                        continue;
                    }
                    this.dPrimes[i][j] = Float.NaN;
                    this.rSquareds[i][j] = Float.NaN;
                    continue;
                }
                this.dPrimes[i][j] = Float.NaN;
                this.rSquareds[i][j] = Float.NaN;
            }
            this.showProgress((double)i / (double)data.size());
        }
    }

    private int countMatches(VariantType[] participantTypes, VariantType target) {
        int result = 0;
        if (participantTypes != null) {
            if (participantTypes.length == 1) {
                if (participantTypes[0] == target) {
                    result = 2;
                }
            } else {
                if (participantTypes[0] == target) {
                    result = 1;
                }
                if (participantTypes[1] == target) {
                    ++result;
                }
            }
        }
        return result;
    }

    public void calculateUnphased() {
        List<VariantRecord> data = this.controller.getData();
        int participantCount = this.controller.getParticipantCount();
        for (int i = 0; i < data.size(); ++i) {
            VariantRecord recI = data.get(i);
            for (int j = i + 1; j < data.size(); ++j) {
                VariantRecord recJ = data.get(j);
                double sumI = 0.0;
                double sumJ = 0.0;
                double squaresI = 0.0;
                double squaresJ = 0.0;
                double prodIJ = 0.0;
                for (int k = 0; k < participantCount; ++k) {
                    VariantType[] varIK = recI.getVariantsForParticipant(k);
                    VariantType[] varJK = recJ.getVariantsForParticipant(k);
                    int countI = 0;
                    int countJ = 0;
                    if (varIK.length == 1) {
                        if (varIK[0] == VariantType.NONE) {
                            countI = 2;
                        }
                    } else {
                        countI = 1;
                    }
                    if (varJK.length == 1) {
                        if (varJK[0] == VariantType.NONE) {
                            countJ = 2;
                        }
                    } else {
                        countJ = 1;
                    }
                    sumI += (double)countI;
                    sumJ += (double)countJ;
                    prodIJ += (double)(countI * countJ);
                    squaresI += (double)(countI * countI);
                    squaresJ += (double)(countJ * countJ);
                }
                double varI = (squaresI /= (double)participantCount) - (sumI /= (double)participantCount) * sumI;
                double varJ = (squaresJ /= (double)participantCount) - (sumJ /= (double)participantCount) * sumJ;
                double covIJ = (prodIJ /= (double)participantCount) - sumI * sumJ;
                this.rSquareds[i][j] = (float)(covIJ * covIJ / (varI * varJ));
            }
            this.showProgress((double)i / (double)data.size());
        }
    }

    protected void showProgress(double fract) {
    }
}

