/*
 * Decompiled with CFR 0.152.
 */
package savant.view.tracks;

import savant.api.adapter.DataSourceAdapter;
import savant.api.adapter.RangeAdapter;
import savant.api.adapter.RecordFilterAdapter;
import savant.api.adapter.VariantDataSourceAdapter;
import savant.api.data.Record;
import savant.api.data.VariantRecord;
import savant.api.data.VariantType;
import savant.api.util.Resolution;
import savant.exception.SavantTrackCreationCancelledException;
import savant.settings.ResolutionSettings;
import savant.util.AxisRange;
import savant.util.AxisType;
import savant.util.ColourKey;
import savant.util.ColourScheme;
import savant.util.DrawingInstruction;
import savant.util.DrawingMode;
import savant.util.Range;
import savant.view.tracks.Track;
import savant.view.tracks.VariantTrackRenderer;

public class VariantTrack
extends Track {
    public VariantTrack(DataSourceAdapter ds) throws SavantTrackCreationCancelledException {
        super(ds, new VariantTrackRenderer());
        this.filter = new ParticipantFilter();
        this.drawingMode = DrawingMode.MATRIX;
    }

    @Override
    public ColourScheme getDefaultColourScheme() {
        return new ColourScheme(ColourKey.A, ColourKey.C, ColourKey.G, ColourKey.T, ColourKey.INSERTED_BASE, ColourKey.DELETED_BASE, ColourKey.N);
    }

    @Override
    public DrawingMode[] getValidDrawingModes() {
        return new DrawingMode[]{DrawingMode.MATRIX, DrawingMode.FREQUENCY};
    }

    @Override
    public void prepareForRendering(String ref, Range r) {
        Resolution res = this.getResolution(r);
        if (res == Resolution.HIGH) {
            this.renderer.addInstruction(DrawingInstruction.PROGRESS, "Retrieving variant data...");
            this.requestData(ref, r);
        } else {
            this.renderer.addInstruction(DrawingInstruction.ERROR, ZOOM_MESSAGE);
            this.saveNullData(r);
        }
        this.renderer.addInstruction(DrawingInstruction.RESOLUTION, (Object)res);
        this.renderer.addInstruction(DrawingInstruction.RANGE, r);
        this.renderer.addInstruction(DrawingInstruction.COLOUR_SCHEME, this.getColourScheme());
        this.renderer.addInstruction(DrawingInstruction.REFERENCE_EXISTS, this.containsReference(ref));
        String[] participants = ((VariantDataSourceAdapter)((Object)this.getDataSource())).getParticipants();
        this.renderer.addInstruction(DrawingInstruction.PARTICIPANTS, participants);
        if (this.getDrawingMode() == DrawingMode.MATRIX) {
            this.renderer.addInstruction(DrawingInstruction.AXIS_RANGE, new AxisRange(r, new Range(0, participants.length)));
        } else {
            this.renderer.addInstruction(DrawingInstruction.AXIS_RANGE, new AxisRange(r, new Range(0, 1)));
        }
        this.renderer.addInstruction(DrawingInstruction.SELECTION_ALLOWED, true);
        this.renderer.addInstruction(DrawingInstruction.MODE, (Object)this.getDrawingMode());
    }

    @Override
    public Resolution getResolution(RangeAdapter range) {
        return range.getLength() > ResolutionSettings.getVariantLowToHighThreshold() ? Resolution.LOW : Resolution.HIGH;
    }

    @Override
    public AxisType getXAxisType(Resolution ignored) {
        return AxisType.NONE;
    }

    @Override
    public AxisType getYAxisType(Resolution ignored) {
        return this.getDrawingMode() == DrawingMode.MATRIX ? AxisType.INTEGER : AxisType.REAL;
    }

    public int getParticipantCount() {
        return ((VariantDataSourceAdapter)((Object)this.getDataSource())).getParticipants().length;
    }

    public String[] getParticipantNames() {
        return ((VariantDataSourceAdapter)((Object)this.getDataSource())).getParticipants();
    }

    private class ParticipantFilter
    implements RecordFilterAdapter {
        public boolean accept(Record rec) {
            VariantRecord varRec = (VariantRecord)rec;
            int count = VariantTrack.this.getParticipantCount();
            for (int i = 0; i < count; ++i) {
                VariantType[] participantVars = varRec.getVariantsForParticipant(i);
                if (participantVars == null || participantVars.length <= 1 && participantVars[0] == VariantType.NONE) continue;
                return true;
            }
            return false;
        }
    }
}

