/*
 * Decompiled with CFR 0.152.
 */
package savant.view.tracks;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.adapter.FrameAdapter;
import savant.view.tracks.Track;
import savant.view.tracks.TrackCreationEvent;

public class TrackCancellationListener
implements ActionListener {
    private static final Log LOG = LogFactory.getLog(TrackCancellationListener.class);
    private final FrameAdapter frame;

    public TrackCancellationListener(FrameAdapter f) {
        this.frame = f;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Track[] tracks = this.frame.getTracks();
        if (tracks.length > 0) {
            LOG.info((Object)("Cancelling data requests for " + tracks.length + " tracks."));
            for (Track t : tracks) {
                t.cancelDataRequest();
            }
        } else {
            LOG.info((Object)"Closing frame for track.");
            this.frame.handleEvent(new TrackCreationEvent(new Exception("Cancelled")));
        }
    }
}

