/*
 * Decompiled with CFR 0.152.
 */
package savant.view.tracks;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import savant.api.adapter.GraphPaneAdapter;
import savant.api.data.Block;
import savant.api.data.Interval;
import savant.api.data.IntervalRecord;
import savant.api.data.Record;
import savant.api.data.RichIntervalRecord;
import savant.api.data.Strand;
import savant.api.util.Resolution;
import savant.exception.RenderingException;
import savant.settings.BrowserSettings;
import savant.util.AxisRange;
import savant.util.ColourKey;
import savant.util.ColourScheme;
import savant.util.DrawingInstruction;
import savant.util.DrawingMode;
import savant.util.IntervalPacker;
import savant.util.MiscUtils;
import savant.util.Range;
import savant.util.StuffedIntervalRecord;
import savant.view.tracks.TrackRenderer;

public class RichIntervalTrackRenderer
extends TrackRenderer {
    private DrawingMode mode;
    Resolution resolution;

    @Override
    public void render(Graphics2D g2, GraphPaneAdapter gp) throws RenderingException {
        this.renderPreCheck();
        this.mode = (DrawingMode)((Object)this.instructions.get((Object)DrawingInstruction.MODE));
        this.resolution = (Resolution)((Object)this.instructions.get((Object)DrawingInstruction.RESOLUTION));
        if (this.mode == DrawingMode.STANDARD) {
            this.renderPackMode(g2, gp, this.resolution);
        } else if (this.mode == DrawingMode.SQUISH) {
            this.renderSquishMode(g2, gp, this.resolution);
        }
        if (this.data.isEmpty()) {
            throw new RenderingException("No data in range", 1);
        }
    }

    private void renderPackMode(Graphics2D g2, GraphPaneAdapter gp, Resolution resolution) throws RenderingException {
        AxisRange axisRange = (AxisRange)this.instructions.get((Object)DrawingInstruction.AXIS_RANGE);
        ColourScheme cs = (ColourScheme)this.instructions.get((Object)DrawingInstruction.COLOUR_SCHEME);
        double unitWidth = gp.getUnitWidth();
        FontMetrics fm = g2.getFontMetrics();
        ArrayList<Record> stuffedRecords = new ArrayList<Record>();
        for (Record r : this.data) {
            RichIntervalRecord ir = (RichIntervalRecord)r;
            int padAmount = 0;
            if (ir.getName() != null) {
                padAmount = (int)((double)(fm.stringWidth(ir.getName()) + 5) / unitWidth);
            }
            stuffedRecords.add(new StuffedIntervalRecord(ir, padAmount, 0));
        }
        IntervalPacker packer = new IntervalPacker(stuffedRecords);
        List<List<IntervalRecord>> intervals = StuffedIntervalRecord.getOriginalIntervals(packer.pack(2));
        gp.setXRange(axisRange.getXRange());
        int numIntervals = intervals.size();
        int maxYRange = numIntervals <= 10 ? 10 : (numIntervals <= 20 ? 20 : (numIntervals <= 50 ? 50 : (numIntervals <= 100 ? 100 : numIntervals)));
        gp.setYRange(new Range(0, maxYRange));
        if (gp.needsToResize()) {
            return;
        }
        for (int level = 0; level < intervals.size(); ++level) {
            List<IntervalRecord> intervalsThisLevel = intervals.get(level);
            for (IntervalRecord intervalRecord : intervalsThisLevel) {
                Interval interval = intervalRecord.getInterval();
                RichIntervalRecord bedRecord = (RichIntervalRecord)intervalRecord;
                this.renderGene(g2, gp, cs, bedRecord, interval, level);
            }
        }
    }

    private void renderGene(Graphics2D g2, GraphPaneAdapter gp, ColourScheme cs, RichIntervalRecord rec, Interval interval, int level) {
        int thickEnd;
        int thickStart;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double unitWidth = gp.getUnitWidth();
        double unitHeight = gp.getUnitHeight();
        int offset = gp.getOffset();
        g2.setFont(BrowserSettings.getTrackFont());
        Color fillColor = (Boolean)this.instructions.get((Object)DrawingInstruction.ITEMRGB) != false && rec.getItemRGB() != null && !rec.getItemRGB().isNull() ? rec.getItemRGB().createColor() : cs.getColor(rec.getStrand() == Strand.FORWARD ? ColourKey.FORWARD_STRAND : ColourKey.REVERSE_STRAND);
        if (((Boolean)this.instructions.get((Object)DrawingInstruction.SCORE)).booleanValue() && !Float.isNaN(rec.getScore())) {
            fillColor = new Color(fillColor.getRed(), fillColor.getGreen(), fillColor.getBlue(), RichIntervalTrackRenderer.getConstrainedAlpha((int)((double)rec.getScore() * 0.255)));
        }
        Color lineColor = cs.getColor(ColourKey.INTERVAL_LINE);
        Color textColor = cs.getColor(ColourKey.INTERVAL_TEXT);
        double startXPos = gp.transformXPos(interval.getStart());
        boolean isInsertion = false;
        if (interval.getLength() == 0) {
            Shape rhombus = this.drawInsertion(g2, gp.transformXPos(interval.getStart()), gp.transformYPos(0.0) - (double)(level + 1) * unitHeight - (double)gp.getOffset(), gp.getUnitWidth(), unitHeight);
            isInsertion = true;
            startXPos -= unitWidth * 0.5;
            this.recordToShapeMap.put(rec, rhombus);
        }
        String geneName = rec.getName();
        if (((Boolean)this.instructions.get((Object)DrawingInstruction.ALTERNATE_NAME)).booleanValue()) {
            geneName = rec.getAlternateName();
        }
        if ((thickStart = rec.getThickStart()) >= (thickEnd = rec.getThickEnd())) {
            thickEnd = -1;
            thickStart = -1;
        } else {
            ++thickEnd;
        }
        double thickStartX = gp.transformXPos(thickStart);
        double thickEndX = gp.transformXPos(thickEnd);
        if (!isInsertion) {
            double yPos = (double)gp.getHeight() - unitHeight * (double)level - unitHeight / 2.0 - (double)offset;
            Area area = new Area();
            List<Block> blocks = rec.getBlocks();
            double chevronIntervalStart = gp.transformXPos(interval.getStart());
            if (blocks == null) {
                blocks = new ArrayList<Block>();
                blocks.add(Block.valueOf(0, interval.getLength()));
            }
            for (Block block : blocks) {
                chevronIntervalStart = Math.max(chevronIntervalStart, 0.0);
                int blockStart = interval.getStart() + block.getPosition();
                int blockEnd = blockStart + block.getSize();
                double x = gp.transformXPos(blockStart);
                double y = (double)gp.getHeight() - unitHeight * (double)(level + 1) - (double)offset;
                double chevronIntervalEnd = x;
                if (chevronIntervalStart < (chevronIntervalEnd = Math.min(chevronIntervalEnd, (double)gp.getWidth())) && chevronIntervalEnd >= 0.0 && chevronIntervalStart <= (double)gp.getWidth()) {
                    g2.setColor(lineColor);
                    g2.draw(new Line2D.Double(chevronIntervalStart, yPos, chevronIntervalEnd, yPos));
                    this.drawChevrons(g2, chevronIntervalStart, chevronIntervalEnd, yPos, unitHeight, rec.getStrand(), area);
                }
                double w = (double)block.getSize() * unitWidth;
                double h = unitHeight;
                Shape blockShape = blockStart >= thickStart ? (blockEnd <= thickEnd ? new Rectangle2D.Double(x, y, w, h) : (blockStart >= thickEnd ? new Rectangle2D.Double(x, y + h * 0.25, w, h * 0.5) : MiscUtils.createPolygon(x, y, thickEndX, y, thickEndX, y + h * 0.25, x + w, y + h * 0.25, x + w, y + h * 0.75, thickEndX, y + h * 0.75, thickEndX, y + h, x, y + h))) : (blockEnd <= thickStart ? new Rectangle2D.Double(x, y + h * 0.25, w, h * 0.5) : (blockEnd <= thickEnd ? MiscUtils.createPolygon(x, y + h * 0.25, thickStartX, y + h * 0.25, thickStartX, y, x + w, y, x + w, y + h, thickStartX, y + h, thickStartX, y + h * 0.75, x, y + h * 0.75) : MiscUtils.createPolygon(x, y + h * 0.25, thickStartX, y + h * 0.25, thickStartX, y, thickEndX, y, thickEndX, y + h * 0.25, x + w, y + h * 0.25, x + w, y + h * 0.75, thickEndX, y + h * 0.75, thickEndX, y + h, thickStartX, y + h, thickStartX, y + h * 0.75, x, y + h * 0.75)));
                g2.setColor(fillColor);
                g2.fill(blockShape);
                if (h > 4.0 && w > 4.0) {
                    g2.setColor(lineColor);
                    g2.draw(blockShape);
                }
                area.add(new Area(blockShape));
                chevronIntervalStart = x + w;
            }
            this.recordToShapeMap.put(rec, area);
        }
        if (geneName != null) {
            g2.setColor(textColor);
            FontMetrics fm = g2.getFontMetrics();
            this.drawFeatureLabel(g2, geneName, startXPos, (double)gp.getHeight() - (double)level * unitHeight - unitHeight * 0.5 + (double)(fm.getHeight() - fm.getDescent()) * 0.5 - (double)offset);
        }
    }

    private void drawChevrons(Graphics2D g2, double start, double end, double y, double height, Strand strand, Area area) {
        int SCALE_FACTOR = 40;
        int interval = ((int)height / 40 + 1) * 40;
        int startPos = start != (double)interval ? (int)start + interval - (int)start % interval : interval;
        for (double x = (double)startPos; x < end; x += (double)interval) {
            double arrowWidth = height * 0.25;
            if (!(end - start > arrowWidth)) continue;
            Path2D.Double arrow = null;
            if (strand == Strand.FORWARD) {
                if (x - arrowWidth > start) {
                    if (height > 40.0) {
                        g2.draw(new Line2D.Double(x, y, x - arrowWidth, y + arrowWidth + 1.0));
                        g2.draw(new Line2D.Double(x, y, x - arrowWidth, y - arrowWidth));
                    } else {
                        arrow = MiscUtils.createPolygon(x, y, x - arrowWidth, y + arrowWidth + 1.0, x - arrowWidth, y - arrowWidth);
                    }
                }
            } else if (x + arrowWidth < end) {
                if (height > 40.0) {
                    g2.draw(new Line2D.Double(x, y, x + arrowWidth, y + arrowWidth + 1.0));
                    g2.draw(new Line2D.Double(x, y, x + arrowWidth, y - arrowWidth));
                } else {
                    arrow = MiscUtils.createPolygon(x, y, x + arrowWidth, y + arrowWidth + 1.0, x + arrowWidth, y - arrowWidth);
                }
            }
            if (arrow == null) continue;
            g2.fill(new Area(arrow));
            if (area == null) continue;
            area.add(new Area(arrow));
        }
    }

    private void renderSquishMode(Graphics2D g2, GraphPaneAdapter gp, Resolution resolution) throws RenderingException {
        int noStrandLevel;
        int negStrandLevel;
        int posStrandLevel;
        ArrayList<Interval> noStrandBlocks;
        ArrayList<Interval> negStrandBlocks;
        ArrayList<Interval> posStrandBlocks;
        Color lineColor;
        Color reverseColor;
        Color forwardColor;
        AxisRange axisRange = (AxisRange)this.instructions.get((Object)DrawingInstruction.AXIS_RANGE);
        gp.setXRange(axisRange.getXRange());
        if (resolution == Resolution.HIGH) {
            ColourScheme cs = (ColourScheme)this.instructions.get((Object)DrawingInstruction.COLOUR_SCHEME);
            forwardColor = cs.getColor(ColourKey.FORWARD_STRAND);
            reverseColor = cs.getColor(ColourKey.REVERSE_STRAND);
            lineColor = cs.getColor(ColourKey.INTERVAL_LINE);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            posStrandBlocks = new ArrayList<Interval>();
            negStrandBlocks = new ArrayList<Interval>();
            noStrandBlocks = new ArrayList<Interval>();
            for (Record record : this.data) {
                RichIntervalRecord bedRecord = (RichIntervalRecord)record;
                Strand strand = bedRecord.getStrand();
                if (strand == Strand.FORWARD) {
                    this.mergeBlocks(posStrandBlocks, bedRecord);
                    continue;
                }
                if (strand == Strand.REVERSE) {
                    this.mergeBlocks(negStrandBlocks, bedRecord);
                    continue;
                }
                if (strand != null) continue;
                this.mergeBlocks(noStrandBlocks, bedRecord);
            }
            posStrandLevel = -1;
            negStrandLevel = -1;
            noStrandLevel = -1;
            int signedStrandCount = posStrandBlocks.size() + negStrandBlocks.size();
            int noStrandCount = noStrandBlocks.size();
            if (signedStrandCount > 0 && noStrandCount > 0) {
                posStrandLevel = 0;
                negStrandLevel = 1;
                noStrandLevel = 2;
                gp.setYRange(new Range(0, 3));
            } else if (signedStrandCount > 0 && noStrandCount == 0) {
                posStrandLevel = 0;
                negStrandLevel = 1;
                gp.setYRange(new Range(0, 2));
            } else if (signedStrandCount == 0 && noStrandCount > 0) {
                noStrandLevel = 0;
            }
            double unitHeight = gp.getUnitHeight();
            if (unitHeight < 1.0) {
                throw new RenderingException("Increase vertical pane size", 0);
            }
            for (Record record : this.data) {
                RichIntervalRecord bedRecord = (RichIntervalRecord)record;
                Strand strand = bedRecord.getStrand();
                int level = strand == Strand.FORWARD ? posStrandLevel : (strand == Strand.REVERSE ? negStrandLevel : noStrandLevel);
                Interval interval = bedRecord.getInterval();
                int startXPos = (int)gp.transformXPos(interval.getStart());
                if (interval.getLength() == 0) {
                    this.drawInsertion(g2, gp.transformXPos(interval.getStart()), gp.transformYPos(0.0) - (double)(level + 1) * unitHeight - (double)gp.getOffset(), gp.getUnitWidth(), unitHeight);
                    continue;
                }
                double yPos = gp.transformYPos(level) - unitHeight * 0.5;
                g2.setColor(lineColor);
                int lineWidth = (int)((double)interval.getLength() * gp.getUnitWidth());
                if (lineWidth <= 4) continue;
                g2.draw(new Line2D.Double(startXPos, yPos, startXPos + lineWidth, yPos));
                this.drawChevrons(g2, startXPos, startXPos + lineWidth, yPos, unitHeight, strand, null);
            }
        } else {
            throw new RenderingException("Zoom in to see genes/intervals", 0);
        }
        this.drawBlocks(posStrandBlocks, posStrandLevel, gp, forwardColor, lineColor, g2);
        this.drawBlocks(negStrandBlocks, negStrandLevel, gp, reverseColor, lineColor, g2);
        this.drawBlocks(noStrandBlocks, noStrandLevel, gp, forwardColor, lineColor, g2);
    }

    private void mergeBlocks(List<Interval> intervals, RichIntervalRecord bedRecord) {
        List<Block> blocks = bedRecord.getBlocks();
        if (blocks == null) {
            blocks = new ArrayList<Block>();
            blocks.add(Block.valueOf(0, bedRecord.getInterval().getLength() - 1));
        }
        Interval gene = bedRecord.getInterval();
        if (intervals.isEmpty()) {
            for (Block block : blocks) {
                int blockStart = gene.getStart() + block.getPosition();
                Interval blockInterval = Interval.valueOf(blockStart, blockStart + block.getSize());
                intervals.add(blockInterval);
            }
        } else {
            for (Block block : blocks) {
                int blockStart = gene.getStart() + block.getPosition();
                Interval blockInterval = Interval.valueOf(blockStart, blockStart + block.getSize());
                ListIterator<Interval> intervalIt = intervals.listIterator();
                boolean merged = false;
                while (intervalIt.hasNext() && !merged) {
                    Interval interval = intervalIt.next();
                    if (!blockInterval.intersectsOrAbuts(interval)) continue;
                    intervalIt.set(blockInterval.merge(interval));
                    merged = true;
                }
                if (merged) continue;
                intervals.add(blockInterval);
            }
        }
    }

    private void drawBlocks(List<Interval> blocks, int level, GraphPaneAdapter gp, Color fillColor, Color lineColor, Graphics2D g2) {
        if (blocks == null || blocks.isEmpty()) {
            return;
        }
        double unitWidth = gp.getUnitWidth();
        double unitHeight = gp.getUnitHeight();
        for (Interval block : blocks) {
            if (block.getLength() == 0) continue;
            double x = gp.transformXPos(block.getStart());
            double y = gp.transformYPos(level) - unitHeight;
            double w = (double)block.getLength() * unitWidth;
            double h = unitHeight;
            Rectangle2D.Double blockRect = new Rectangle2D.Double(x, y, w, h);
            g2.setColor(fillColor);
            g2.fill(blockRect);
            if (!(h > 4.0) || !(w > 4.0)) continue;
            g2.setColor(lineColor);
            g2.draw(blockRect);
        }
    }

    @Override
    public Dimension getLegendSize(DrawingMode mode) {
        switch (mode) {
            case STANDARD: {
                return new Dimension(150, 78);
            }
            case SQUISH: {
                return new Dimension(150, 60);
            }
        }
        return null;
    }

    @Override
    public void drawLegend(Graphics2D g2, DrawingMode mode) {
        ColourScheme cs = (ColourScheme)this.instructions.get((Object)DrawingInstruction.COLOUR_SCHEME);
        int x = 6;
        int y = 17;
        g2.setColor(cs.getColor(ColourKey.FORWARD_STRAND));
        g2.fillRect(x, y - 10, 36, 12);
        g2.setColor(cs.getColor(ColourKey.INTERVAL_LINE));
        g2.drawRect(x, y - 10, 36, 12);
        g2.setColor(Color.BLACK);
        g2.setFont(LEGEND_FONT);
        g2.drawString(ColourKey.FORWARD_STRAND.getName(), x + 45, y);
        g2.setColor(cs.getColor(ColourKey.REVERSE_STRAND));
        g2.fillRect(x, (y += 18) - 10, 36, 12);
        g2.setColor(cs.getColor(ColourKey.INTERVAL_LINE));
        g2.drawRect(x, y - 10, 36, 12);
        g2.setColor(Color.BLACK);
        g2.drawString(ColourKey.REVERSE_STRAND.getName(), x + 45, y);
        g2.setColor(cs.getColor(ColourKey.INTERVAL_LINE));
        g2.drawLine(x, y += 15, x + 36, y);
        g2.fill(MiscUtils.createPolygon(x + 15, y - 4, x + 19, y, x + 15, y + 5));
        g2.setColor(Color.BLACK);
        g2.drawString("Intron", x + 45, y += 3);
        if (mode == DrawingMode.STANDARD) {
            g2.setColor(cs.getColor(ColourKey.FORWARD_STRAND));
            g2.fillRect(x, (y += 18) - 8, 36, 6);
            g2.setColor(cs.getColor(ColourKey.INTERVAL_LINE));
            g2.drawRect(x, y - 8, 36, 6);
            g2.setColor(Color.BLACK);
            g2.drawString("Non-coding", x + 45, y);
        }
    }
}

