/*
 * Decompiled with CFR 0.152.
 */
package savant.view.tracks;

import savant.api.adapter.DataSourceAdapter;
import savant.api.adapter.RangeAdapter;
import savant.api.util.Resolution;
import savant.exception.SavantTrackCreationCancelledException;
import savant.util.AxisRange;
import savant.util.ColourKey;
import savant.util.ColourScheme;
import savant.util.DrawingInstruction;
import savant.util.Range;
import savant.view.tracks.PointTrackRenderer;
import savant.view.tracks.Track;

public class PointTrack
extends Track {
    public PointTrack(DataSourceAdapter dataSource) throws SavantTrackCreationCancelledException {
        super(dataSource, new PointTrackRenderer());
    }

    @Override
    public ColourScheme getDefaultColourScheme() {
        return new ColourScheme(ColourKey.POINT_FILL, ColourKey.POINT_LINE);
    }

    @Override
    public Resolution getResolution(RangeAdapter range) {
        return range.getLength() > 100000 ? Resolution.LOW : Resolution.HIGH;
    }

    @Override
    public void prepareForRendering(String ref, Range r) {
        Resolution res = this.getResolution(r);
        switch (res) {
            case HIGH: {
                this.renderer.addInstruction(DrawingInstruction.PROGRESS, "Retrieving data...");
                this.requestData(ref, r);
                break;
            }
            default: {
                this.saveNullData(r);
            }
        }
        this.renderer.addInstruction(DrawingInstruction.RESOLUTION, (Object)res);
        this.renderer.addInstruction(DrawingInstruction.COLOUR_SCHEME, this.getColourScheme());
        this.renderer.addInstruction(DrawingInstruction.AXIS_RANGE, new AxisRange(r, new Range(0, 1)));
        this.renderer.addInstruction(DrawingInstruction.REFERENCE_EXISTS, this.containsReference(ref));
        this.renderer.addInstruction(DrawingInstruction.SELECTION_ALLOWED, true);
    }
}

