/*
 * Decompiled with CFR 0.152.
 */
package savant.view.tracks;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import savant.api.adapter.GraphPaneAdapter;
import savant.api.data.ContinuousRecord;
import savant.api.data.Record;
import savant.api.event.DataRetrievalEvent;
import savant.controller.LocationController;
import savant.exception.RenderingException;
import savant.selection.SelectionController;
import savant.util.AxisRange;
import savant.util.ColourKey;
import savant.util.ColourScheme;
import savant.util.DrawingInstruction;
import savant.util.Range;
import savant.view.tracks.ContinuousTrack;
import savant.view.tracks.TrackRenderer;

public class ContinuousTrackRenderer
extends TrackRenderer {
    private static final Log LOG = LogFactory.getLog(ContinuousTrackRenderer.class);

    @Override
    public void handleEvent(DataRetrievalEvent evt) {
        switch (evt.getType()) {
            case COMPLETED: {
                float[] extremes = ContinuousTrack.getExtremeValues(evt.getData());
                Range range = (Range)this.instructions.get((Object)DrawingInstruction.RANGE);
                if (range == null) break;
                this.addInstruction(DrawingInstruction.AXIS_RANGE, new AxisRange(range, new Range(Math.min(0, (int)Math.floor((double)extremes[0] * 1.05)), Math.max(0, (int)Math.ceil((double)extremes[1] * 1.05)))));
            }
        }
        super.handleEvent(evt);
    }

    @Override
    public void render(Graphics2D g2, GraphPaneAdapter gp) throws RenderingException {
        this.renderPreCheck();
        AxisRange axisRange = (AxisRange)this.instructions.get((Object)DrawingInstruction.AXIS_RANGE);
        gp.setXRange(axisRange.getXRange());
        gp.setYRange(axisRange.getYRange());
        if (gp.needsToResize()) {
            return;
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ColourScheme cs = (ColourScheme)this.instructions.get((Object)DrawingInstruction.COLOUR_SCHEME);
        Color fillcolor = cs.getColor(ColourKey.CONTINUOUS_FILL);
        Color linecolor = cs.getColor(ColourKey.CONTINUOUS_LINE);
        GeneralPath path = new GeneralPath();
        double xFormXPos = Double.NaN;
        double xFormYPos = Double.NaN;
        double yPixel0 = gp.transformYPos(0.0);
        LOG.debug((Object)("h=" + gp.getHeight() + ", yMin=" + gp.getYRange().getFrom() + ", unitHeight=" + gp.getUnitHeight() + " \u27a4 yPixel0=" + yPixel0));
        double maxData = 0.0;
        boolean haveOpenPath = false;
        boolean haveData = false;
        if (this.data != null) {
            for (int i = 0; i < this.data.size(); ++i) {
                ContinuousRecord continuousRecord = (ContinuousRecord)this.data.get(i);
                int xPos = continuousRecord.getPosition();
                float yPos = continuousRecord.getValue();
                if (Float.isNaN(yPos)) {
                    if (haveOpenPath) {
                        path.lineTo(xFormXPos, yPixel0);
                        path.closePath();
                        haveOpenPath = false;
                    }
                } else {
                    haveData = true;
                    xFormXPos = gp.transformXPos(xPos);
                    xFormYPos = gp.transformYPos(yPos);
                    if (!haveOpenPath) {
                        path.moveTo(xFormXPos, yPixel0);
                        haveOpenPath = true;
                    }
                    path.lineTo(xFormXPos, xFormYPos);
                    Rectangle2D.Double rec = new Rectangle2D.Double(xFormXPos - (xFormXPos - path.getCurrentPoint().getX()) / 2.0, 0.0, Math.max(xFormXPos - path.getCurrentPoint().getX(), 1.0), gp.getHeight());
                    this.recordToShapeMap.put(continuousRecord, rec);
                    xFormXPos = gp.transformXPos(xPos + 1);
                    path.lineTo(xFormXPos, xFormYPos);
                }
                if (!((double)yPos > maxData)) continue;
                maxData = yPos;
            }
        }
        if (!haveData) {
            throw new RenderingException("No data in range", 1);
        }
        if (haveOpenPath) {
            path.lineTo(xFormXPos, yPixel0);
            path.closePath();
        }
        g2.setColor(fillcolor);
        g2.fill(path);
        g2.setColor(linecolor);
        g2.draw(path);
        if (axisRange.getYRange().getFrom() < 0) {
            g2.setColor(Color.darkGray);
            g2.draw(new Line2D.Double(0.0, yPixel0, gp.getWidth(), yPixel0));
        }
    }

    @Override
    public List<Shape> getCurrentSelectedShapes(GraphPaneAdapter gp) {
        ArrayList<Shape> shapes = new ArrayList<Shape>();
        List<Record> currentSelected = SelectionController.getInstance().getSelectedFromList(this.trackName, LocationController.getInstance().getRange(), this.data);
        for (int i = 0; i < currentSelected.size(); ++i) {
            shapes.add(ContinuousTrackRenderer.continuousRecordToEllipse(gp, currentSelected.get(i)));
        }
        return shapes;
    }

    public static Shape continuousRecordToEllipse(GraphPaneAdapter gp, Record o) {
        ContinuousRecord rec = (ContinuousRecord)o;
        Double x = gp.transformXPos(rec.getPosition()) + gp.getUnitWidth() / 2.0 - 4.0;
        Double y = gp.transformYPos(rec.getValue()) - 4.0;
        Ellipse2D.Double s = new Ellipse2D.Double(x, y, 8.0, 8.0);
        return s;
    }
}

